import java.math.*;
import java.awt.geom.*;

/**This class  defines our dyadic planar sets, as well as the routines used in the proof.  There are 3 types of boxes:

type 0: square
type 1: segment
type 2: the point infinity

*/



public class Box {
    static int SCALE=30;
    static int TOL=18;
    Complex z;     //the center
    GaussianInteger g; //2^{SCALE} times the center
    int k;               // - log_2 of the sidelength
    int type;         


    public Box() {}

    /**specifies a box of type t by its center and -log of the sidelength**/

    public Box(Complex zz,int kk,int t) {
	this.z=zz;
	this.k=kk;
        this.type=t;
	this.g=GaussianInteger.convert(zz,SCALE);
    }

    /**copies a box**/

    public Box(Box B) {
	this.z=new Complex(B.z);
	this.k=B.k;
	this.g=new GaussianInteger(B.g);
	this.type=B.type;
    }


    /**Prints out the box**/

    public void print() {
	System.out.print("type "+type+" size "+k+" center ");
	z.print();
	g.print();
    }

    /**Gets the vertices of a box.  The routine is
       designed so that the first two vertices are
       farthest apart in the inverse stereographic
       metric on the plane. That is, inverse
       stereographic projection maps the first two
       vertices the farthest apart*/

    public Complex[] toVertices() {

	if(type==2) return null;

	double d=Math.pow(.5,k+1);

	if(type==1) {
           Complex[] Z=new Complex[2];
	   Z[0]=new Complex(z.x-d,z.y);
	   Z[1]=new Complex(z.x+d,z.y);
	   return(Z);
	}

        Complex[] Z=new Complex[4];

	Z[0]=new Complex(z.x+d,z.y-d);
	Z[1]=new Complex(z.x-d,z.y-d);
	Z[2]=new Complex(z.x-d,z.y+d);
	Z[3]=new Complex(z.x+d,z.y+d);
	return Z;
    }

    /**Gets numbers which are the vertices of the box scaled up by 2^SCALE**/

    public GaussianInteger[] toGaussianVertices() {

	if(type==2) return null;

	long d=(long)(Math.pow(2,SCALE-k-1));

	if(type==1) {
           GaussianInteger[] Z=new GaussianInteger[2];
	   Z[0]=new GaussianInteger(g.x-d,g.y);
	   Z[1]=new GaussianInteger(g.x+d,g.y);
	   return(Z);
	}

        GaussianInteger[] G=new GaussianInteger[4];

	G[0]=new GaussianInteger(g.x+d,g.y-d);
	G[1]=new GaussianInteger(g.x-d,g.y-d);
	G[2]=new GaussianInteger(g.x-d,g.y+d);
	G[3]=new GaussianInteger(g.x+d,g.y+d);
	return(G);

    }


    /**This is the main routine for subdividing a box.  **/


     public Box subdivide0(int choice) {
 	Complex[] Z=toVertices();
	GaussianInteger[] G=toGaussianVertices();
 	Complex w=Complex.average(Z[choice],z);
 	Box B=new Box(w,k+1,0);
	B.g=GaussianInteger.average(G[choice],g);
 	return(B);
     }


    /**This routine is used for the box Q0 
       contained on the real axis.  This is really 
       just an interval, so it is subdivided in half*/

    public Box subdivide1(int i) {
	Complex[] Z=toVertices();	
        GaussianInteger[] G=toGaussianVertices();
	Complex w=Complex.average(Z[i],z);
	Box B=new Box(w,k+1,1);
	B.g=GaussianInteger.average(G[i],g);
	return(B);
    }



    /**Basic quantities associated to a box**/

    public long rad() {
	long r=(long)(Math.pow(2,SCALE-k-1));
	return r;
    }

    public long xMin() {
	return g.x-rad();
    }

    public long xMax() {
	return g.x+rad();
    }

    public long yMin() {
	return g.y-rad();
    }

    public long yMax() {
	return g.y+rad();
    }


    /**converts a box to a graphics object*/

    public Path2D.Double toPath() {
	Complex[] Z=toVertices();
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<Z.length;++i) {
	    if(i==0) gp.moveTo(Z[i].x,Z[i].y);
	    if(i>0)  gp.lineTo(Z[i].x,Z[i].y);
	}
	gp.closePath();
	return(gp);
    }

    public Path2D.Double toPath2() {
	Complex[] Z=toVertices();
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(-1.5,-1.5);
	gp.lineTo(z.x,z.y);
	gp.closePath();
	return(gp);
    }

}
