import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,KeyListener {
    Manager M;
    ControlPanel MAIN,PROOFMODE,DEBUG,INIT,ELIM;
    Parameter[][] ENERGY=new Parameter[3][2];
    SelectInteger ENERGY1,ENERGY2;
    Parameter TOL,SCALE;
    Proof PROOF;    
    Anneal ANNEAL;
    ProofMonitor PC;
    ListenSquare GO,HALT;     
    PopupManager PM;
    ListenSquare[] INFO=new ListenSquare[2];
    Lever SPEED;



     public ControlCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 ControlPanelSetup.main(this);
         setButtons();
	 PM=new PopupManager(null,181,0);
         PROOF=new Proof();   
         ANNEAL=new Anneal();    
	 PC=new ProofMonitor(260,0);
	 SPEED=new Lever(100,210,0,20);

	 String[][] c1={{"1","3"},{"0","0"},{"0","0"}};

	 for(int i=0;i<3;++i) {
	    ENERGY[i][0]=new Parameter(293+90*i,153,52,c1[i][0]);
	    ENERGY[i][1]=new Parameter(340+90*i,153,25,c1[i][1]);
	 }
	 ENERGY2=new SelectInteger(465,183,40,20,0,0,7,1);
	 TOL=new Parameter(100,180,30,"18");
	 SCALE=new Parameter(198,180,25,"30");
	 INFO[0]=new ListenSquare(249,0,12,12);
	 INFO[1]=new ListenSquare(542,0,12,12);
     }

    public void setButtons() {
	GO=new ListenSquare(0,147,25,20,Color.red); GO.on=1;
	HALT=new ListenSquare(0,214,35,20,Color.red); HALT.on=1;	
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      makeFrame(g);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      drawPanels(g);    
      drawButtons(g);
      PM.render(g); 
      INFO[0].infoRender(g);
      INFO[1].infoRender(g);   	  
   }

    public void makeFrame(Graphics2D g) {
    g.setColor(new Color(100,0,160));
      g.fillRect(0,0,getWidth(),getHeight()); 
    

    }

    public void drawButtons(Graphics2D g) {
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      if(PROOF.HALT==true) { 
          GO.render(g,new Color(0,180,0));
          g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
      }
      if((ANNEAL.HALT==false)||(PROOF.HALT==false)) {
	  HALT.render(g,new Color(220,0,0));
          g.drawString("stop",(int)(HALT.x+5),(int)(HALT.y+15));

      }
   
    }

    public void drawPanels(Graphics2D g) {
       MAIN.render(g,0,0,85);
       if(MAIN.mode==0) {
            PROOFMODE.render(g,0,70,85);
            ELIM.render2(g,90,0,85);
       }
       if(MAIN.mode==1) DEBUG.render(g,getWidth()-166,0,165);
       g.setColor(new Color(200,0,200));
       g.fillRect(0,147,getWidth()-1,87);
       g.setColor(Color.white);
       g.drawRect(0,147,getWidth()-1,87);
       if(MAIN.mode==0) PC.render(g);
       ENERGY2.render(g,Color.blue,Color.white,new Color(0,0,0,0));
       g.setColor(Color.white);	
       g.setFont(new Font("Helvetica",Font.PLAIN,16));
       g.drawString("energy combo",185,169);
       g.drawString("use arrows for energy presets ",245,197);
       g.drawString("+",369,168);
       g.drawString("+",459,168);
       for(int i=0;i<3;++i) {
	   for(int j=0;j<2;++j) {
	       ENERGY[i][j].render(g);
	   }
       }
       TOL.render(g,Color.red);
       SCALE.render(g,Color.red);	
       g.setFont(new Font("Helvetica",Font.PLAIN,15));
       g.drawString("in-rad.:",45,TOL.y+15);
       g.drawString("depth:",SCALE.x-48,SCALE.y+15);
       SPEED.render(g,"",new Color(0,200,0));
       g.drawString("speed",45,225);
  }



  public void updatePanels(Point X) { 
      if(PROOF.HALT==false) return;  
      if(MAIN.mode==0) PROOFMODE.switchMode(X);
      if(MAIN.mode==1) DEBUG.switchMode(X); 
      MAIN.switchMode(X);
  }


 
    /**Gets the energy combo to be tested*/
   public int[][] getEnergy() {
    int[][] E=new int[3][2];
    for(int i=0;i<3;++i) {
        for(int j=0;j<2;++j) {
        E[i][j]=ENERGY[i][j].getVal();
        }
    }
    return E;
   }
 
 
    /**Tells which elimination features to use in the test*/
 
    public int[] eliminationSpecs() {
    int[] elim=new int[5];
    for(int i=0;i<5;++i) elim[i]=M.C.ELIM.L[i].on;
        return elim;
    }
 



    public boolean isSpecial() {
	for(int i=0;i<3;++i) {
	    if(ENERGY[i][0].getVal()<0) return true;
	}
	return false;
    }

     public void doRun() {
	 if(MAIN.mode==0) doRunProof();
	 if(MAIN.mode==1) doRunDebug();
	 if(MAIN.mode==2) doRunAnneal();
     }


     public void doRunProof() {
	 if(PROOF.HALT==true) {
             PROOF=new Proof(this.M);
	     new Thread(PROOF).start();
	}
    }

     public void doRunAnneal() {
	 if(ANNEAL.HALT==true) {
	     System.out.println("OK");
             ANNEAL=new Anneal(this.M);
	     new Thread(ANNEAL).start();
	}
    }

     public void doRunDebug() {
	 Debug.run(DEBUG.mode,M);
    }


    public void doStop() {
	PROOF.HALT=true;
	ANNEAL.HALT=true;
    }

  public void documentStuff(Point X) {
        if(PROOFMODE.L[20].inside(X)==1) DocumentControl.proofmode(M.D);
        if(MAIN.L[20].inside(X)==1) DocumentControl.action(M.D);
        if(ELIM.L[20].inside(X)==1) DocumentControl.grade(M.D);
	if(DEBUG.L[20].inside(X)==1) DocumentControl.debugmode(M.D);
	if(INFO[1].inside(X)==1) DocumentControl.monitor(M.D);
	if(INFO[0].inside(X)==1) DocumentControl.popups(M.D);
    }

    public void setEnergy(MouseEvent e) {
      for(int i=0;i<3;++i) {
	 for(int j=0;j<2;++j) {
	    ENERGY[i][j].process(e);
	 }
      }   
      MouseData J=MouseData.process(e);
      ENERGY2.modify(J.X);
      if(ENERGY2.isModified(J.X)==1) {
	  Integer t=new Integer(ENERGY2.val);
          if(t==0) EnergyPresets.G(3,ENERGY);
          if(t==1) EnergyPresets.G(4,ENERGY);
          if(t==2) EnergyPresets.G5Flat(ENERGY);
          if(t==3) EnergyPresets.G(6,ENERGY);
	  if(t==4) EnergyPresets.G10SharpSharp(ENERGY);
	  if(t==5) EnergyPresets.G10Sharp(ENERGY);
	  if(t<5) M.C.ELIM.L[3].on=0;
	  if(t==5) M.C.ELIM.L[3].on=1;
      }
    }
    
    public void mouseClicked(MouseEvent e) { 
	PM.M=this.M;
        MouseData J=MouseData.process(e);
	PM.process(J.X);
        updatePanels(J.X); 
	documentStuff(J.X);
        if(GO.inside(J.X)==1) doRun();
        if(HALT.inside(J.X)==1) doStop();
	setEnergy(e);
	TOL.process(e);
	SCALE.process(e);
	SPEED.process(J.X);
	ELIM.toggle(J.X);

	//doTest();
        M.repaint();
    }

    public void doTest() {}



    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

    public void keyTyped(KeyEvent e) {
	for(int i=0;i<3;++i) {
	   ENERGY[i][0].processKey(false,e);
	   ENERGY[i][1].processKey(true,e);
	}
	SCALE.processKey(true,e);
	TOL.processKey(true,e);
	Box.TOL=TOL.getVal();
	Box.SCALE=SCALE.getVal();
	M.repaint();
    }
 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}



}

