import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

public class Debug {

    /**This file has the debugging routines*/

    public static void run(int k,Manager M) {
	if(k==0) checkVectorRoutines();
	if(k==1) checkIntervalArithmetic();
	if(k==2) checkPowerOfTwo();
	if(k==3) checkInverseStereo(3);
	if(k==4) checkSphericalOperations(3);
	if(k==5) checkEnergyTheorem(M);
    }

    public static void checkVectorRoutines() {
	Vector V=DebugSupport.randomVector(10);
	Vector W=DebugSupport.randomVector(10);
	double s=DebugSupport.randomInt(10);

	Vector X=new Vector();

	System.out.println("check vector operations");
	System.out.println("random vectors  ");
	System.out.print("V                 "); 
        V.print();
	System.out.print("W                 ");
	W.print();
	System.out.print("scale s           "+s);
	System.out.println("");

	System.out.print("plus(V,W)         ");
	X=Vector.plus(V,W);
	X.print();

	System.out.print("minus(V,W)        ");
	X=Vector.minus(V,W);
	X.print();

	System.out.print("V.scale(d)        ");
	X=V.scale(s);
	X.print();

	System.out.print("dot(V,W)          ");
	double d=Vector.dot(V,W);
	System.out.println(d);

	System.out.print("distSquared(V,W)  ");
        d=Vector.distSquared(V,W);
	System.out.println(d);
	System.out.println("----------------");
    }


    public static void checkIntervalArithmetic() {
	System.out.println("---------");
	double d1=Math.random();
	double d2=Math.random();
	Interval D1=Interval.fat(d1);
	Interval D2=Interval.fat(d2);

	System.out.println("first double");
	System.out.println(" "+d1);
	D1.print();
	System.out.println("");

	System.out.println("second double");
	System.out.println(" "+d2);
	D2.print();
	System.out.println("");

	System.out.println("plus");
	double e1=d1+d2;
	Interval E1=Interval.plus(D1,D2);
	System.out.println(" "+e1);
	E1.print();
	System.out.println(DebugSupport.inside(e1,E1));
	System.out.println("");

	System.out.println("minus");
	double e2=d1-d2;
	Interval E2=Interval.minus(D1,D2);
	System.out.println(" "+e2);
	E2.print();
	System.out.println(DebugSupport.inside(e2,E2));	
        System.out.println("");

	System.out.println("times");
	double e3=d1*d2;
	Interval E3=Interval.times(D1,D2);
	System.out.println(" "+e3);
	E3.print();
	System.out.println(DebugSupport.inside(e3,E3));	
        System.out.println("");

	System.out.println("divide");
	double e4=d1/d2;
	Interval E4=Interval.divide(D1,D2);
	System.out.println(" "+e4);
	E4.print();
	System.out.println(DebugSupport.inside(e4,E4));	
        System.out.println("");

	System.out.println("max");
	double e5=Math.max(d1,d2);
	Interval E5=Interval.max(D1,D2);
	System.out.println(" "+e5);
	E5.print();
	System.out.println(DebugSupport.inside(e5,E5));	
        System.out.println("");

	System.out.println("min");
	double e6=Math.min(d1,d2);
	Interval E6=Interval.min(D1,D2);
	System.out.println(" "+e6);
	E6.print();
	System.out.println(DebugSupport.inside(e6,E6));	
        System.out.println("");

	System.out.println("power");
	for(int q=0;q<=6;++q) {
	    double e7=Math.pow(d1,q);
	    Interval E7=Interval.pow(D1,q);
	    System.out.println(" "+e7);
	    E7.print();
	    System.out.println(DebugSupport.inside(e7,E7));	
            System.out.println("");
	}

    }

    public static void checkPowerOfTwo() {

	System.out.println("powers of 2");
	for(int i=-10;i<40;++i) {
	    BigDecimal d1=new BigDecimal("1.0");
	    BigDecimal d2=new BigDecimal("0.5");
	    for(int j=0;j<i;++j) {
		d1=d1.multiply(d2);
	    }
	    Interval I=Interval.inversePower2(i);
	    Double IL=new Double(I.l);
	    Double IR=new Double(I.r);
	    BigDecimal IIL=new BigDecimal(IL.toString());
	    BigDecimal IIR=new BigDecimal(IR.toString());
	    int test1=d1.compareTo(IIL);
	    int test2=d1.compareTo(IIR);

	    System.out.println("Exponent "+i);
	    I.print();
	    System.out.println("interval containment "+test1+" "+test2);
	}


    }

    public static void checkInverseStereo(int k) {
	int[] m=new int[k];
	for(int i=0;i<k;++i) m[i]=DebugSupport.randomIntPos(4);
	Box B=DebugSupport.getBox(m);
	Complex[] Z=B.toVertices();
	Vector V=Vector.inverseStereo(Z[0]);
	System.out.println("InverseStereo(B.Z[0])       ");
        V.print();
	GaussianInteger[] G=B.toGaussianVertices();
	IntervalVector IV=IntervalVector.inverseStereo(G[0]);
	System.out.println("Interval InverseStereo(B.G[0])       ");
	IV.print();
	System.out.println("containment");
	for(int i=0;i<3;++i) {
	    boolean test=DebugSupport.inside(V.x[i],IV.x[i]);
	    System.out.println(test);
	}

    }

    public static void checkSphericalOperations(int k) {

	/**These are boxes of type 0*/
	int[] m1=new int[k];
	for(int i=0;i<k;++i) m1[i]=DebugSupport.randomIntPos(4);
	Box BB1=DebugSupport.getBox(m1);

	int[] m2=new int[k];
	for(int i=0;i<k;++i) m2[i]=DebugSupport.randomIntPos(4);
	Box BB2=DebugSupport.getBox(m2);

	int[] m3=new int[k];
	for(int i=0;i<k;++i) m1[i]=DebugSupport.randomIntPos(2);
	Box BB3=DebugSupport.getSegment(m3);

	int[] m4=new int[k];
	for(int i=0;i<k;++i) m4[i]=DebugSupport.randomIntPos(2);
	Box BB4=DebugSupport.getSegment(m4);

	Box B1=new Box(BB1);
	Box B2=new Box(BB2);
	double t1=Math.random();
	double t2=Math.random();
	if(t1<.5) B1=new Box(BB3);
	if(t2<.5) B2=new Box(BB4);

	if(t1<.25) B2=Block.initialBox2();

	System.out.println("type "+B1.type+" "+B2.type);


	Vector[] V1=SphericalMeasures.sphereVectors(B1);
	IntervalVector[] IV1=IntervalSphericalMeasures.sphereVectors(B1);

	Vector[] V2=SphericalMeasures.sphereVectors(B2);
	IntervalVector[] IV2=IntervalSphericalMeasures.sphereVectors(B2);

	System.out.println("");
	System.out.println("spherical vectors");
	for(int i=0;i<V1.length;++i) {
	    V1[i].print();
	    IV1[i].print();
	    System.out.println(DebugSupport.inside(V1[i],IV1[i]));
	}


	System.out.println("");
	System.out.println("spherical center of mass");
	IntervalVector ICM=IntervalSphericalMeasures.centerOfMassSpherical(B1);
	Vector CM=SphericalMeasures.centerOfMassSpherical(B1);
	CM.print();
	ICM.print();
	System.out.println(DebugSupport.inside(CM,ICM));


	System.out.println("");
	System.out.println("hull diameter squared");
	double d1=SphericalMeasures.hullDiameterSquared(B1);
	Interval D1=IntervalSphericalMeasures.hullDiameterSquared(B1);
	System.out.println(d1);
	D1.print();
	System.out.println(DebugSupport.inside(d1,D1));


	System.out.println("");
	System.out.println("max side diameter squared");
	double d2=SphericalMeasures.sideDiameterMaxSquared(B1);
	Interval D2=IntervalSphericalMeasures.sideDiameterMaxSquared(B1);
	System.out.println(d2);
	D2.print();
	System.out.println(DebugSupport.inside(d2,D2));


	System.out.println("");
	System.out.println("crude measure squared");
	double d3=SphericalMeasures.crudeMeasureSquared(B1);
	Interval D3=IntervalSphericalMeasures.crudeMeasureSquared(B1);
	System.out.println(d3);
	D3.print();
	System.out.println(DebugSupport.inside(d3,D3));


	System.out.println("");
	System.out.println("hull separation constant");
	double d4=SphericalMeasures.hullSepConstant(B1);
	Interval D4=IntervalSphericalMeasures.hullSepConstant(B1);
	System.out.println(d4);
	D4.print();
	System.out.println(DebugSupport.inside(d4,D4));

	System.out.println("");
	System.out.println("dot max lower");
	double d6=SphericalMeasures.dotMaxUpper(B1,B2);
	Interval D6=IntervalSphericalMeasures.dotMaxUpper(B1,B2);
	System.out.println(d6);
	D6.print();
	System.out.println(DebugSupport.inside(d6,D6));


	System.out.println("");
	System.out.println("epsilon(B1,B2)");
	double d7=EliminateEnergy.epsilon(3,B1,B2);
	Interval D7=EliminateEnergyInterval.epsilon(3,B1,B2);
	System.out.println(d7);
	D7.print();
	System.out.println(DebugSupport.inside(d7,D7));


	System.out.println("type "+B1.type+" "+B2.type);

    }

    public static void checkEnergyTheorem(Manager M) {

	int[][] E=M.C.getEnergy();
	System.out.println("energy combo");
	for(int i=0;i<3;++i) {
	    System.out.println(E[i][0]+" "+E[i][1]);
	}

	Block B=new Block();
	try{B=M.P.getBlock();}
	catch(Exception e) {
	    System.out.println("open up the blocks window to run this.");
            return;
	}

	double d1=EliminateEnergy.minVertexEnergy(E,B);
	 double[] d2=EliminateEnergy.ERR(E,B);
	 double d3=d1-d2[0];
	 System.out.println("Energy Lower Bound from Theorem:         "+d3);

	 double min=1000000;
	 for(int i=0;i<100000;++i) {
	     Complex[] Z=DebugSupport.getRandom(B);
	     double d=Energy.energy(E,Z);
	     if(min>d) min=d;
	 }
	 System.out.println("Min of 1000000 random configs in block:  "+min);
	 if(min>d3) System.out.println("bound works");
	 if(min<d3) System.out.println("*****BOUND FAILS*****");
    }


}




