
/**This class has some auxiliary routines which we use in connection
   with the debugging feature*/

public class DebugSupport {


    /**checks if an interval contains a point*/

    public static boolean inside(double d,Interval I) {
	if(d<I.l) return false;
	if(d>I.r) return false;
	return true;
    }


    /**Checks if a vector is inside in IntervalVector,
       componentwise*/

    public static boolean inside(Vector V,IntervalVector IV) {
	for(int i=0;i<3;++i) {
	    if(inside(V.x[i],IV.x[i])==false) return false;
	}
	return true;
    }

    /**gets a random integer between -k and k*/
    public static int randomInt(int k) {
	double d=2*k*Math.random()-k;
	return (int)(Math.floor(d));
    }

    /**gets a random integer between 0 and k-1 inclusive*/
    public static int randomIntPos(int k) {
	double d=k*Math.random()-.0000001;
	if(d<=0) d=.0000001;
	return (int)(Math.floor(d));
    }

    /**gets a randon integer vector with coordinates
       between -k and k*/

    public static Vector randomVector(int k) {
	Vector V=new Vector();
	for(int i=0;i<3;++i) V.x[i]=randomInt(k);
	return V;
    }

    public static Block randomBlock3() {
	int[] size={3,3,3,3};
	return randomBlock(size);
    }

    /**This gets a random block*/
    public static Block randomBlock(int[] size) {
	Block X=new Block();
	int[] s=new int[4];
	for(int i=0;i<4;++i) s[i]=2+size[i];
	Complex[] z=RandomGenerator.randomConfig();
	int[] type={1,0,0,0};
	for(int i=0;i<4;++i) {
	   X.B[i]=new Box(z[i],size[i],type[i]);
	}
	return X;
    }


    /**This gives a random dyadic square of depth at most k*/

    public static Box getBox(int[] k) {
	Box B=Block.initialBox0();
	for(int i=0;i<k.length;++i) {
	    B=B.subdivide0(k[i]);
	}
	return B;
     }

    /**This gets a random dyadic segment*/

    public static Box getSegment(int[] k) {
	Box B=Block.initialBox1();
	for(int i=0;i<k.length;++i) {
	    B=B.subdivide1(k[i]);
	}
	return B;
     }



    /**sampling points inside blocks and boxes*/

    /**This gets a random configuration in a block*/

    public static Complex[] getRandom(Block B) {
	Complex[] Z=new Complex[4];
	for(int i=0;i<4;++i) Z[i]=getRandom(B.B[i]);
	return Z;
    }


    /**This gets a random point inside a box*/

    public static Complex getRandom(Box B) {
	if(B.type==1) return getRandom1(B);
	return getRandom0(B);
    }

    public static Complex getRandom0(Box B) {
	Complex[] Z=B.toVertices();
	double[] d=new double[4];
	double tot=0;

	for(int i=0;i<4;++i) {
            d[i]=Math.random();
	    tot=tot+d[i];
	}
	for(int i=0;i<4;++i) d[i]=d[i]/tot;

	double x=0;
	double y=0;
	for(int i=0;i<4;++i) {
	    x=x+d[i]*Z[i].x;
	    y=y+d[i]*Z[i].y;
	}
	return new Complex(x,y);
    }

    /**Gets a random number inside a dyadic segment*/

    public static Complex getRandom1(Box B) {
	Complex[] Z=B.toVertices();
	double d=Math.random();
	double x=d*Z[0].x+(1-d)*Z[1].x;
	double y=0;
	return new Complex(x,y);
    }




}

