import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentBlock {

    public static void sendTo(DocumentCanvas D,String S) {
        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }


    public static void display(DocumentCanvas D) {
	String S="display";
	S=S+"\n\nThis control panel toggles the diaplay of the triangular bi-pyramid configuration in polar position.  The first button draws edges between various points of the configuration.";

S=S+"\n\nThe second button specifies the small neighborhood of the TBP as specified by the radius button on the main control panel.  To see this feature clearly, set the radius to about 2. (You have to be in the advanced mode to change the value of the radius.)  Then experiment with changing the size of the radius.";

	sendTo(D,S);
    }

    public static void block(DocumentCanvas D) {
	String S="block control";
	S=S+"\n\nThis tall thin cluster of buttons lets you select your own block.  The buttons are color coded so that all the buttons of the same color control the same dyadic square or segment.  The green buttons control the dyadic segment, and the other buttons control the dyadic squares. There are 4 things you can do with these buttons.";

	S=S+"\n\nSubdivision:  Using the small 2x2 (or 2x1) button clusters at the top you can subdivide the block as described in the paper. Just try pushing these buttons and seeing what happens.";

	S=S+"\n\nUnsubdivision: Using the larger buttons next to the 2x2 button clusters, you can undo the subdivision.  Try pushing the subdivision buttons a few times and then undoing them with these buttons.";

	S=S+"\n\nMotion: Using the 3x3 (or 3x1) button clusters at the bottom, you can move the components of the blocks around.";

	S=S+"\n\nRandom: If you press the random button, you select a block at random.  The sizes of the component squares and segments do not change; just the positions.";


	sendTo(D,S);
    }


    public static void grader(DocumentCanvas D) {
	String S="grading window";
	S=S+"\n\nThis window shows the calculations which go into the grading step of the main algorithm.  The step is applied to the block selected on the block window.  So, to have this window function correctly, you should also have the block window open";

	S=S+"\n\nWhen the block pass the grading step, the word pass will appear somewhere on the window, depending on the step which causes the block to pass. When the block fails, the word fail will appear and a colored square will appear.  The colored square gives you the subdivision recommendation.  If you click one of the subdivision squares of this color on the block window, you can see what it is like to subject one of the subdivided pieces to the grading algorithm.  If you keep doing this iteratively, eventually the block will pass.";

	S=S+"\n\nThe most important quantity on the grading window is the one which reads 'block energy lower'. This is the output of the Energy Theorem. It is our lower bound to the minimum energy of a configuration associated to the block. If this is higher than the energy of the TBP, the block passes the last and main step of the grading.";

	sendTo(D,S);
    }


    public static void connect(DocumentCanvas D) {
	String S="display options";
	S=S+"\n\nconnectors: This toggles an option to draw segments connecting the centers of the squares in the block.  The use of this feature, when on, is that you can keep track of the squares when they are very small.";


	S=S+"\n\nfailures: There are two ways to view the output of the divide-and-conquer algorithm.  With this feature off, just the passed blocks are shown.  With this feature, both failed and passed blocks are shown, with the failures shown in outline and the passes shown solidly.  The `pass only' display leads to the algorithm running more quickly but the `pass and fail' option gives a better understanding of how the subdivision works.";

	sendTo(D,S);
    }


    public static void proofmode(DocumentCanvas D) {
	String S="calculation type selector";

	S=S+"\n\nYou can run the proof in 3 ways:";

	S=S+"\n\nfloating point calculations:  These calculations do not constitute a rigorous proof of the main result in the paper.  However, they are a very good indication of how the rigorous calcualations will do.";

	S=S+"\n\ninterval arithmetic:  These calculations are the ones advertised in the paper.  They take about 4 times as long to run as the floating point calculations.  You can get a rough idea of how long it takes to run them by looking at the proof monitor as the proof is running.";

	S=S+"\n\ninteger:  These calculations are much slower. I don't know how long it takes to run them to completion.  I've never done it all the way.";

	sendTo(D,S);
    }



    public static void monitor(DocumentCanvas D) {
	String S="proof monitor";

	S=S+"\n\nWhen you run the proof, the algorithm sends various pieces of information to this monitor, so that you can see the progress of the program:";

	S=S+"\n\ntime:  This keeps track of the total time the proof has been running.";

	S=S+"\n\nPartition size:  Ultimately the program produces a partition of the configuration space into blocks such that each block passes the grading.  The partition goal shows the total number of blocks in the partition and the white number keeps track of how many blocks of the partition have been passed. The program will stop when the two numbers are equal.";

	S=S+"\n\nVolume: This keeps track of the percentage of the total volume of the configuration space which the program has passed.  We keep track of this as a lfloating point number, so the final answer will be a tiny bit less than 1.";

S=S+"\n\n max depth:  As the program runs, the dyadic squares and segments comprising the block are subdivided.  This number keeps track of the deepest nested subdivision.   The program would abort and declare failure if this number ever reached 25.";

S=S+"\n\n list length:  The number keeps track of the number of blocks on the current list.  The number in parens keeps track of the longest that the list ahs been up to the current moment.";



	sendTo(D,S);
    }
}


