import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void action(DocumentCanvas D) {
	String S="action mode";
	S=S+"\n\nThere are two main modes for this program. In the proof mode, you can run the algorithm discussed in the paper.  When you are in this mode, you can select the kind of calculations you want to make: floating point or interval.  You can also select the energy exponent for the choices 3,4,5,6.  When you press GO the program is launched. you halt the program at any time by pressing STOP.";

	S=S+"\n\nWhen you run the proof, the program interacts with the block window. As each block is passed, it is sent to the Block window and displayed.  If you want to see a nice animation, you should open the block window and run the program.";

	S=S+"\n\nIn the debug mode you can run several auxiliary programs which serve as sanity checks that the program is operating correctly.  If you click the question box on the debug window you can see a description of what these do.";

	sendTo(D,S);
    }


    public static void advanced(DocumentCanvas D) {
	String S="basic/advanced mode";

	S=S+"\n\nIn the basic mode, certain parameters are set for you and others are restricted.  All you can do in the basic mode is choose the exponent for the energy functional.  You are only allowed to pick exponents 3,4,5,6, because these are the ones tested in the paper.  That is, you can test G3,G4,G5,G6.  You make the selection using the arrow keys at the bottom.  The TBP radius is set at 2^(-15) and the subdivision depth is set at 25.";

	S=S+"\n\nIn the advanced mode, you have more flexibility. You can manually select any energy function of the form aA+bB+cC where a,b,c are integers and A,B,C are various of the G functions.  The choice for the energy in the paper is (a,b,c)=(1,28,102) and (A,B,C)=(G10,G5,G2).  You make the selection by clicking inside the blue fields and using the keyboard.  The coefficients a,b,c can be positive or negative, but the exponents A,B,C must be positive.  There are also arrow keys which cycle through the 5 energies considered in the paper, namely G3,G4,G5,G6, and G10 + 28 G5 +102 G2.";

S=S+"\n\n  In the advanced mode, you can select the TPB radius and the subdivision depth.  If you open up the BLOCKS window you can see the effect of changing the TBP radius.";

	S=S+"\n\nIn the advanced mode, you can also control the speed of the program.  The leftmost setting is the fastest, with no delay.  The slower speeds are allowed for demonstration purposes.";

	sendTo(D,S);
    }


    public static void popups(DocumentCanvas D) {
	String S="popup windows";
	S=S+"\n\nThis control console lets you launch 3 auxiliary windows. One of them is the info window, which you are now reading.  The other two windows allow you to display, manipulate, and analyze blocks.";

	S=S+"\n\nWhen the program is running the proof, the Block window displays each block as it is being passed by the algorithm. So, in principle, if you could slow down the program and watch the block window you would see the entire partition of the configuration space being drawn dynamically.  The program works too fast for this, and you just get to see a nice animation.";

	S=S+"\n\nWhen the program is in the debug mode, you can use the controls on the block window to select and manipulate blocks.  Once you choose a block, the grading window will subject it to the main step of the algorithm. This lets you see how the algorithm decides whether to pass a given block.  Of course, the block you select may not actually arise during the running of the algorithm.";



	sendTo(D,S);
    }



    public static void debugmode(DocumentCanvas D) {
	String S="debugging options";

	S=S+"\n\nvector operations: This operation selects two random integer vectors and computes their dot product, their sum, etc.  You can check this against some other program, like Mathematica, to see that these basic operations are programmed correctly.";

	S=S+"\n\ninterval arithmetic: This operation checks our interval arithmetic implementation for gross errors.  Given a double d, we have an operation called fat(d), which produces the interval D=[d1,d2], where d1 is obtained by rounding d down one click and d2 is obtained by rounding d up one click.  This routine takes two doubles a and b, sets A=fat(a) and B=fat(B) and then considers the basic operations performed on A and B.  The routine checks that each operation produces an interval which traps the same floating point operation performed on a and b.  We check plus, minus, times, divide, max, min, and power.";

	S=S+"\n\npower of 2 lookup:  To save time with some calculations, we store the inverse powers of 2 up to 2^{-25}.  This routine just checks that the floating point computation (a') of such a power of 2 fits inside the interval made by taking the lookup value (a) and placing it inside the interval A=fat(a).";



	S=S+"\n\nstereographic projection:  This routine just checks that the interval version of our stereographic projection agrees (in the appropriate sense) with our floating point version.  What is nontrivial here is that the floating point version is computed from the a complex number z whereas the interval version is computed using the gaussian integer obtained by scaling z up by 2^{25}.  We only apply our operations to those z for which the corresponding g really is an integer.  The interval version works by multiplying g by 2^{-25} and then doing the formula for stereographic projection.  So, we just wanted to check that we did not make a mistake when implementing this.";

	S=S+"\n\nSpherical measure functions:  This computes all the functions which go into our Energy Theorem, and checks that the interval versions match the gloating point versions in the appropriate sense.  The appropriate sense is that the floating point quantity is always trapped in the interval quantity.";

	S=S+"\n\nCheck Energy Theorem:  This option should be used in tandem with the block window.  When the block window is open, this option does two things. First, it computes the lower energy bound given by the theorem.  Second, it computes the actual energy of a million randomly chosen configurations in the block and then takes the minimum. The check is that the min-random energy is greater than the bound from the theorem.";


	sendTo(D,S);
    }

    public static void grade(DocumentCanvas D) {
	String S="grading algorithm modifier";

	S=S+"\n\nThis crucial control panel specifies how the grading algorithm works.  There are 5 options.  The first 3 should be turned on for all the calculations associated to the Big Theorem.  The first 4 should be turned on for the calculation associated to the Small Theorem.  The 5th one is just a debugger.  Here is a description of the options.";

	S=S+"\n\nirrelevant: This eliminates irrelevant blocks, as specified in the monograph.  These are blocks which contain configurations that are permuted in some way other than the correct way.";

	S=S+"\n\nfar out: This eliminates blocks which are too far from the origin, as specified by the monograph.";

	S=S+"\n\nnear TBP: This eliminates blocks which are too near the triangular bi-pyramid, as specified in the monograph.  The notion of 'near' is controlled by the in-rad number field entry.  The default is that this number is set to 18, which means that a block is eliminated if it is within 2^{-18} of the TBP in the max norm.";

	S=S+"\n\nin SMALL: This eliminates blocks which are inside the region SMALL described in the monograph and plotted in the picture window.  Again, this should be turned on when the calculation for the Small Theorem is run.";

	S=S+"\n\ndebug: Currently, this eliminates any blocks which are disjoint from the region SMALL.  The use of this feature is as follows. If we want to see whether we can slightly decreae the size of SMALL and still get the program to run to completion, we turn on the debug option so that we don't waste time making calculations we already know about.";

	sendTo(D,S);
    }

    public static void proofmode(DocumentCanvas D) {
	String S="calculation type selector";

	S=S+"\n\nYou can run the proof in 2 ways:";

	S=S+"\n\nfloating point calculations:  These calculations do not constitute a rigorous proof of the main result in the paper.  However, they are a very good indication of how the rigorous calcualations will do.";

	S=S+"\n\ninterval arithmetic:  These calculations are the ones advertised in the paper.  They take about 5 times as long to run as the floating point calculations.  You can get a rough idea of how long it takes to run them by looking at the proof monitor as the proof is running.  The interval arithmetic calculations still rely on floating point calculations in a sense.  To save time, we only apply interval arithmetic calculations to blocks which pass the grading step based on floating point calculations.  So, the actual partition is produced in a non-rigorous way but then the produced partition is rigorously certified to work.  This still constitutes a proof.";
	sendTo(D,S);
    }



    public static void monitor(DocumentCanvas D) {
	String S="proof monitor";

	S=S+"\n\nWhen you run the proof, the algorithm sends various pieces of information to this monitor, so that you can see the progress of the program:";

	S=S+"\n\ntime:  This keeps track of the total time the proof has been running.";

	S=S+"\n\nPartition size:  Ultimately the program produces a partition of the configuration space into blocks such that each block passes the grading.  This keeps track of how many blocks of the partition have been passed.";

	S=S+"\n\nVolume: This keeps track of the percentage of the total volume of the configuration space which the program has passed.  We keep track of this as a lfloating point number, so the final answer will be a tiny bit less than 1.";

S=S+"\n\n max depth:  As the program runs, the dyadic squares and segments comprising the block are subdivided.  This number keeps track of the deepest nested subdivision.   The program would abort and declare failure if this number ever reached 25.";

S=S+"\n\nThis displays the current dimensions of the block being eliminated.  The 4 numbers s1,s2,s3,s4 indicate that  the current block has the form (Q0,Q1,Q2,Q3) where Qk has side length 2^{-sk}.  Here $Q1 is a dyadic segment and Q2,Q3,Q4 are dyadic squares.";

S=S+"\n\n list length:  The number keeps track of the number of blocks on the current list.  The number in parens keeps track of the longest that the list ahs been up to the current moment.";

	sendTo(D,S);
    }







}


