import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class EliminateInsideSmall {

    public static boolean main(Block X) {
       	if(inBox(0,X.B[0],Box.SCALE)==false) return false;
       	if(inBox(1,X.B[1],Box.SCALE)==false) return false;
       	if(inBox(2,X.B[2],Box.SCALE)==false) return false;
       	if(inBox(3,X.B[3],Box.SCALE)==false) return false;
	return true;
    }

    public static boolean inBox(int j,Box B,int scale) {
	GaussianInteger[] z=B.toGaussianVertices();
	for(int i=0;i<z.length;++i) {
	    if(inBox(j,z[i],scale)==false) return false;
	}
	return true;
    }

    /**This tests whether the complex number represented
       by the Gaussian integer is contained in the jth
       factor of the special neighborhood of the TBP.*/

    public static boolean inBox(int j,GaussianInteger g,int scale) {
	int[] n=DataSMALL.data(j);
        long x0=scaleNum(n[0],512,scale);
        long x1=scaleNum(n[1],512,scale);	 
        long y0=scaleNum(n[2],512,scale);
        long y1=scaleNum(n[3],512,scale);
        if(g.y<y0) return false;
	if(g.y>y1) return false;	
        if(g.x<x0) return false;
	if(g.x>x1) return false;
	return true;
    }

    /**q should be a smallish power of 2*/
    public static long scaleNum(long p,long q,long scale) {
	long x=(long)(1.0*p*Math.pow(2,scale)/q);
	return x;
    }

}
