import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class EliminateNearTBP {

    public static boolean main(Block X) {
	for(int i=0;i<4;++i) {
	    if(inBox(i,X.B[i],Box.TOL,Box.SCALE)==false) return false;
	}
	return true;
    }


    /**Tests whether the box B is contained in the
       jth factor of the special neighborhood of the TBP.
       We check that all the vertices are in the box,
       using the next routine.*/

    public static boolean inBox(int j,Box B,int tol,int scale) {
	GaussianInteger[] z=B.toGaussianVertices();
	for(int i=0;i<z.length;++i) {
	    if(inBox(j,z[i],tol,scale)==false) return false;
	}
	return true;
    }


    /**This tests whether the complex number represented
       by the Gaussian integer is contained in the jth
       factor of the special neighborhood of the TBP.*/

    public static boolean inBox(int j,GaussianInteger z,int tol,int scale) {
	if(j==0) return inBox0(z,tol,scale);
	if(j==1) return inBox1(z,tol,scale);
	if(j==2) return inBox2(z,tol,scale);
	if(j==3) return inBox3(z,tol,scale);
	return false;
    }


    public static boolean inBox0(GaussianInteger g,int tol,int scale) {
	if(nearOne(g.x,tol,scale)==false) return false;
	return true;
    }

    public static boolean inBox1(GaussianInteger g,int tol,int scale) {
	if(nearZero(g.x,tol,scale)==false) return false;
	if(nearSpecialMinus(g.y,tol,scale)==false) return false;
	return true;
    }

    public static boolean inBox2(GaussianInteger g,int tol,int scale) {
	if(nearOneMinus(g.x,tol,scale)==false) return false;
	if(nearZero(g.y,tol,scale)==false) return false;
	return true;
    }

    public static boolean inBox3(GaussianInteger g,int tol,int scale) {
	if(nearZero(g.x,tol,scale)==false) return false;
	if(nearSpecialPlus(g.y,tol,scale)==false) return false;
	return true;
    }


    public static boolean nearSpecialMinus(long x,int tol,int scale) {
	return nearSpecialPlus(-x,tol,scale);
    }

    public static boolean nearSpecialPlus(long x,int tol,int scale) {
	long target=special(scale);
	return nearTarget(true,x,target,tol,scale);
    }

    public static boolean nearOneMinus(long x,int tol,int scale) {
	return nearOne(-x,tol,scale);
    }

    public static boolean nearOne(long x,int tol,int scale) {
	long target=(long)(Math.pow(2,scale));
	return nearTarget(x,target,tol,scale);
    }

    public static boolean nearZero(long x,int tol,int scale) {
	long target=0;
	return nearTarget(x,target,tol,scale);
    }


    /**The true case deals with sqrt(3)/3, where the approximation
       is inexact*/

    public static boolean nearTarget(boolean narrow,long x,long target,int tol,int scale) {

	long radius=(long)(Math.pow(2,scale-tol));
	long lo=target-radius;
	long hi=target+radius;
	if(narrow==true) lo=lo+1;
	if(narrow==true) hi=hi-1;
	if(x<lo) return false;
	if(x>hi) return false;
	return true;
    }

    public static boolean nearTarget(long x,long target,int tol,int scale) {
	return nearTarget(false,x,target,tol,scale);
    }

    /**This returns the greatest integer less than 2^n Sqrt(3)/3.
       Her we really should take n<100*/

    public static long special(int n) {
	BigDecimal s=new BigDecimal("0.577350269189625764509148780501957455647601751270126876018");
	BigInteger t0=new BigInteger("2");
	t0=t0.pow(n);
	BigDecimal t=new BigDecimal(t0.toString());
	BigDecimal u=t.multiply(s);
	BigInteger v=u.toBigInteger();
	return v.longValue();
    }




}
