import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class EliminateOutsideSmall {

    public static boolean main(Block X) {
	if(constraint0(X.B[0],Box.SCALE)==true) return true;
	if(constraint1(X.B[1],Box.SCALE)==true) return true;
	if(constraint2(X.B[2],Box.SCALE)==true) return true;
	if(constraint3(X.B[3],Box.SCALE)==true) return true;
	return false;
    }


    public static boolean isEastOf(long p,long q,long scale,Box B) {
	GaussianInteger[] z=B.toGaussianVertices();
	long E=scaleNum(p,q,scale);
	for(int i=0;i<z.length;++i) {
	    if(z[i].x<E) return false;
	}
	return true;
    }

    public static boolean isWestOf(long p,long q,long scale,Box B) {
	GaussianInteger[] z=B.toGaussianVertices();
	long W=scaleNum(p,q,scale);
	for(int i=0;i<z.length;++i) {
	    if(z[i].x>W) return false;
	}
	return true;
    }


    public static boolean isNorthOf(long p,long q,long scale,Box B) {
	GaussianInteger[] z=B.toGaussianVertices();
	long N=scaleNum(p,q,scale);
	for(int i=0;i<z.length;++i) {
	    if(z[i].y<N) return false;
	}
	return true;
    }

    public static boolean isSouthOf(long p,long q,long scale,Box B) {
	GaussianInteger[] z=B.toGaussianVertices();
	long S=scaleNum(p,q,scale);
	for(int i=0;i<z.length;++i) {
	    if(z[i].y>S) return false;
	}
	return true;
    }

    public static boolean constraint0(Box B,int scale) {
	if(isWestOf(27,32,scale,B)==true) return true;
	if(isEastOf(249,256,scale,B)==true) return true;
	return false;
    }


    public static boolean constraint1(Box B,int scale) {
	if(isWestOf(-1,32,scale,B)==true) return true;
	if(isEastOf(+1,32,scale,B)==true) return true;
	if(isSouthOf(-29,32,scale,B)==true) return true;
	if(isNorthOf(-21,32,scale,B)==true) return true;
	return false;
    }

    public static boolean constraint2(Box B,int scale) {
	if(isEastOf(-25,32,scale,B)==true) return true;
	if(isWestOf(-249,256,scale,B)==true) return true;
	if(isSouthOf(0,1,scale,B)==true) return true;
	if(isNorthOf(+3,64,scale,B)==true) return true;
	return false;
    }

    public static boolean constraint3(Box B,int scale) {
	if(isWestOf(-1,32,scale,B)==true) return true;
	if(isEastOf(+1,32,scale,B)==true) return true;
	if(isSouthOf(21,32,scale,B)==true) return true;
	if(isNorthOf(29,32,scale,B)==true) return true;
	return false;
    }

    /**q should be a smallish power of 2*/
    public static long scaleNum(long p,long q,long scale) {
	long x=(long)(1.0*p*Math.pow(2,scale)/q);
	return x;
    }


}