import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class Energy {


    /**This is the fundamental routine*/

    public static double interaction(int e,Vector V1,Vector V2) {
	double d=2+2*Vector.dot(V1,V2);
	d=Math.pow(d,e);
	return(d);
    }

    /**This routine computes the total energy of 
       4 points in the plane, plus the point at
       infinity.  These 4 points are  mapped 
       stereographically to the unit sphere, and
       the vector (0,0,1) is included as the 
       image of infinity.  */

    public static double energy(int e,Complex[] z) {
	Vector[] V=new Vector[5];
	for(int i=0;i<4;++i) V[i]=Vector.inverseStereo(z[i]);
	V[4]=new Vector(0,0,1);

	double total=0;
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		total=total+interaction(e,V[i],V[j]);
	    }
	}
	return(total);
    }

    public static double energy(int[][] E,Complex[] z) {
	double tot=0;
	for(int i=0;i<3;++i) {
	    double abs=Math.abs(E[i][0]);
	    if(abs>.0000001) {
               tot=tot+E[i][0]*energy(E[i][1],z);
	    }
	}
	return tot;
    }




}


