import java.awt.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;



public class GridDrawer {

    /**This draws the grid for the picture window*/

    public static void drawGrid(PictureCanvas P,Graphics2D g,int t) {

	int s=t-5;
	Color[] C={new Color(0,0,150),
                   new Color(0,0,190),
                   new Color(0,0,220),
                   new Color(0,0,250),
                   new Color(20,40,250),
                   new Color(40,100,255),
                   new Color(50,120,255)};
	Color CC=Color.orange;
	for(int i=5;i>-2;--i) {
	    if(i<=t) CC=C[5-i+s];
	    if(i<=t) drawGrid(P,g,i,1,CC);
	}
    }



    public static void drawGrid(PictureCanvas P,Graphics2D g,int k, double thick,Color C) {
	Path2D.Double gp=new Path2D.Double();
	double d0=Math.pow(2,k);
	double d1=d0;

	for(int i=(int)(-2*d1);i<=2*d1;++i) {
	    float x=(float)(1.0*i/d0);
	    float y1=(float)(-2);
	    float y2=-y1;
	    gp.moveTo(x,y1);
	    gp.lineTo(x,y2);
	}

	for(int i=(int)(-2*d1);i<=2*d1;++i) {
	    float y=(float)(1.0*i/d0);
	    gp.moveTo(-2,y);
	    gp.lineTo(2,y);
	}

	g.setStroke(new BasicStroke((float)(thick)));
	gp=P.transform(gp);
	g.setColor(C);
	g.draw(gp);	
	g.setStroke(new BasicStroke(1));
    }

    public static void drawZone(PictureCanvas P,Graphics2D g) {
      Path2D.Double gp=new Path2D.Double();
      for(int i=0;i<4;++i) {
         gp=DataSMALL.graphics(i);
         gp=P.transform(gp);
         g.setColor(new Color(0,255,255,100));
         g.fill(gp);
         g.setColor(new Color(0,255,255));
         g.draw(gp);
      }
    }



    public static void drawDiamond(PictureCanvas P,Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(1,0);
	double a=Math.sqrt(3)/3;
	gp.lineTo(0,a);
	gp.lineTo(-1,0);
	gp.lineTo(0,-a);
	gp.closePath();
	g.setColor(new Color(140,0,250,100));
	gp=P.transform(gp);
	g.fill(gp);
    }


    public static Path2D.Double unitCircle() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(1,0);
	double PI=Math.PI;
	for(int i=0;i<1000;++i) {
	    double t=2.0*i*PI/1000;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    gp.lineTo(c,s);
	}
	return gp;
    }



}
