import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**The manager lets the program communicate with
   the main windows.  
   The HALT variable says whether the program is running.
   LIST is the list of configurations
   COUNT is the length of the list
   PASSED keeps track of the number passed;
   TOTAL keeps track of the volume of blocks passed.*/
   

public class Proof implements Runnable {
    Manager M;
    boolean HALT;
    Block[] LIST=new Block[300];
    int COUNT;
    int MAXCOUNT;
    long TIME;
    long PASSED;
    double TOTAL;
    int MAXDEPTH;
    int[] LOG=new int[300];
    int[] CURRENTDEPTH=new int[4];

    public Proof() {
	HALT=true;
    }

    /**This is the construction method for the program*/

    public Proof(Manager MM) {
	this.M=MM;
        Box.SCALE=M.C.SCALE.getVal();
        Box.TOL=M.C.TOL.getVal();
	HALT=true;
	COUNT=1;
	TOTAL=0;
	PASSED=0;
        LIST[0]=Block.initialBox();
	for(int i=0;i<200;++i) LOG[i]=0;		
    }


    /**Here is the runnable routine*/

    public void run() {	
        HALT=false;
	TIME=System.currentTimeMillis();
	sendMessage();
	int mode=M.C.PROOFMODE.mode;
	int[][] E=M.C.getEnergy();
	int[] elim=M.C.eliminationSpecs();
	int speed=M.C.SPEED.val;
	int testchoice=M.C.MAIN.mode; // 0=regular, 1=symm test

 	while((HALT==false)&&(COUNT>0)) {
	    delay(M.C.SPEED.val);
	    mainStep(mode,elim,E);
	}
	sendMessage();
	HALT=true;
    }


    /**The main step in the algorithm.*/

    public void mainStep(int mode,int[] elim,int[][] E) {   
 	 int[] test={0,0};
         Block X=new Block(LIST[COUNT-1]);
	 boolean rigor=false;
	 if(mode==1) rigor=true;
	 test=ProofGrading.main(rigor,elim,E,X);
	 if(test[0]==0)  subdivide(X,test[1]);
	 if(test[0]==1)  eliminate(X);  
	 if(MAXCOUNT<COUNT) MAXCOUNT=COUNT;
         displayTime();
    }


    /**This is a time-delay just for display purposes*/

    public void delay(int k) {
	if(k==0) return;
	double d=1000*Math.pow(2,k)/Math.pow(2,20);
	long a=System.currentTimeMillis();
	boolean test=false;
	while(test==false) {
	    long b=System.currentTimeMillis();
	    if(b-a>d) test=true;
	}
    }


    /** elimination: we display the eliminated block
        on the picture window*/

    public void eliminate(Block X) {
	--COUNT;
	++LOG[14+X.volumeLog()];  
        for(int i=0;i<4;++i) CURRENTDEPTH[i]=X.B[i].k;
	int depth=X.maxDepth();
	if(MAXDEPTH<depth) MAXDEPTH=depth;
	++PASSED;
	displayBlock(X,1);
    }

    /**Subdivision: The integer q tells which subdivision to perform.**/

    public void  subdivide(Block X,int q) {
	int disp=0;
	try{disp=M.P.DISPLAY.L[1].on;}
	catch(Exception e) {};

	if(disp==1) displayBlock(X,0);
	--COUNT;
	if(q==0) {
	   for(int n=0;n<2;++n) {
	      LIST[COUNT]=X.subdivide1(n);
	      ++COUNT;
	   }
	}

	if(q!=0) {
	  for(int n=0;n<4;++n) {
	  LIST[COUNT]=X.subdivide0(q,n);
	  ++COUNT;
	  }
	}
    }

    /**These routines aren't part of the proof, but they are used to 
       mark the progress of the program.**/

    public void displayTime() {
	 double[] time=new double[10];
         double tt=System.currentTimeMillis()-TIME;
	 sendMessage();
    }


    /**The message sent to the main window*/

    public void sendMessage() {
	computeVolume();
	String T=Time.convert(System.currentTimeMillis()-TIME);
	M.C.PC.time=T;
	M.C.PC.VOLUME=TOTAL;   //volume eliminated
	M.C.PC.PASSED=PASSED;
	M.C.PC.K=0;
	M.C.PC.MODE=0;
	M.C.PC.MAXDEPTH=MAXDEPTH;
	M.C.PC.CURRENTDEPTH=CURRENTDEPTH;
	M.C.PC.LENGTH=COUNT;
	M.C.PC.MAXLENGTH=MAXCOUNT;
	M.repaint();
    }


    public void computeVolume() {
         double total=0;
	 for(int i=0;i<200;++i) {
	   total=total+LOG[i]*Math.pow(.5,i);
	 } 
         TOTAL=total;
    }


    public void displayBlock(Block X,int fill) {
	try{
	   M.P.Z=Block.centerDisplay(X);
	   M.P.FILL=fill;
	   for(int i=0;i<4;++i) M.P.SC.size[i]=X.B[i].k;
	   M.repaint();
	}
	catch(Exception e) {}
    }


 


}


