import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;






public class ScaleCanvas extends Canvas implements MouseListener, MouseMotionListener {
    Complex SOURCE=new Complex(0,0);
    AffineTransform[] A=new AffineTransform[2];
    Point JX;


     public ScaleCanvas() {
     }

    public void setScales(int m,int n) {
	A[0]=AffineTransform.getTranslateInstance(m,m);
	A[1]=AffineTransform.getScaleInstance(n,-n);
    }


    public void setScales(int m1,int m2,int n) {
	A[0]=AffineTransform.getTranslateInstance(m1,m2);
	A[1]=AffineTransform.getScaleInstance(n,-n);
    }



    /**double buffering - seems to run automatically without 
       explicitly being invoked in the paint routine.*/
    public void update(Graphics g) {
        Graphics g2;
        Image offscreen = null;
        offscreen = createImage(this.getWidth(),this.getHeight());
        g2 = offscreen.getGraphics();
        paint(g2);
        g.drawImage(offscreen, 0, 0, this);
	g2.dispose();
	offscreen.flush();
    }
    /**end double buffering*/



    /**These routines draw rectangles and squares **/

    public void drawRectangle(Graphics2D g,Color C1,Color C2,double x1,double y1,double x2,double y2) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo((float)(x1),(float)(y1));
	gp.lineTo((float)(x2),(float)(y1));
	gp.lineTo((float)(x2),(float)(y2));
	gp.lineTo((float)(x1),(float)(y2));
	gp.closePath();
	gp=transform(gp);
	g.setColor(C1);
	g.fill(gp);
	g.setColor(C2);
	g.draw(gp);
    }

    public void drawRectangle(Graphics2D g,Color C1,Color C2,double[] d) {
	drawRectangle(g,C1,C2,d[0],d[1],d[2],d[3]);
    }

    public void drawSquare(Graphics2D g,Color C1,Color C2,Complex z,double t) {
	Path2D.Double gp=getSquare(z,t);
	gp=transform(gp);
	g.setColor(C1);
	g.fill(gp);
	g.setColor(C2);
	g.draw(gp);
    }

    public Path2D.Double getSquare(Complex z,double t) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo((float)(z.x-t),(float)(z.y-t));
	gp.lineTo((float)(z.x+t),(float)(z.y-t));
	gp.lineTo((float)(z.x+t),(float)(z.y+t));
	gp.lineTo((float)(z.x-t),(float)(z.y+t));
	gp.closePath();
	return gp;
    }



    public void paint(Graphics g2) {}

    public Path2D.Double transform(Path2D.Double H) {
	Path2D.Double HH=new Path2D.Double(H);
	HH.transform(A[1]);   //scale
	HH.transform(A[0]);   //translate
	return(HH);
    }

    public void scaleNicely(Path2D.Double gp) {
	int w=this.getWidth();
	int h=this.getHeight();
	AffineTransform[] AFF=GraphicsHelp.preFit(gp,0,0,w,h);
	A[0]=AFF[0];
	A[1]=AFF[1];
    }



    /**ZOOM: This routine is the companion to the scaling routine.  
       After I have zoomed into the picture in some way, my further
       mouse clicks have different meanings than they did before the
       zoom.  In other words, suppose that I dilate the picture by
       100000.  When I click on the point with pixel value (50,50)
       I really mean to select the number (.00005,.00005). This routine
       changes the pixel value of the point to the intended value.*/

    public Complex unTransform(Point X) {
	double ux=A[0].getTranslateX();
       double uy=A[0].getTranslateY();
       double tx=X.x;
       double ty=X.y;

       double sx=A[1].getScaleX();
       double sy=A[1].getScaleY();
       ux=(ux-tx)+tx;
       uy=(uy-ty)+ty;
       tx=tx-ux;
       ty=ty-uy;
       tx=tx/sx;
       ty=ty/sy;
       return(new Complex(tx,ty));
    }


    /**ZOOM: this routine scales up or down with the mouse click.
       The first argument is the point about which you scale, and
       the second argument just tells you whether to go up or down.
       The basic idea is that I have globally defined some
       AffineTransform objects.  These will rescale a Path2D.Double
       whenever I draw it.  So, I just modify the components of
       these AffineTransforms whenever I do this routine.*/
       



    public void scaleUp(Point X,int k) {

	double scale=Math.pow(2,1.0/4.0);
	double ss=scale;
	if(k==1) ss=1/scale;

	double sx=A[1].getScaleX();
	double sy=A[1].getScaleY();
	double tx=X.x;
	double ty=X.y;
	double ux0=A[0].getTranslateX();
	double uy=A[0].getTranslateY();

	double ux1=ss*(ux0-tx)+tx;
	uy=ss*(uy-ty)+ty;
	sx=sx*ss;
        sy=sy*ss;
	A[1]=AffineTransform.getScaleInstance(sx,sy);
	A[0]=AffineTransform.getTranslateInstance(ux1,uy);
	repaint();
    }




    public void drawSource(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	float x=(float)(SOURCE.x);
	float y=(float)(SOURCE.y);
	gp.moveTo((float)(x-.001),(float)(y-.001));
	gp.lineTo((float)(x-.001),(float)(y+.001));
	gp.lineTo((float)(x+.001),(float)(y+.001));
	gp.lineTo((float)(x+.001),(float)(y-.001));
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.white);
	g.fill(gp);
	g.draw(gp);
    }

    public void doScale(MouseEvent e,Manager M) {
        MouseData J=MouseData.process(e);
	int mode=J.mode;
        if(mode==1) scaleUp(J.X,-1);
        if(mode==3) scaleUp(J.X,+1);
	if(mode==2) {
            Complex temp=unTransform(J.X);
	    SOURCE=temp;
	}
    }

    public void doScale2(MouseEvent e,Manager M) {
        MouseData J=MouseData.process(e);
	int mode=J.mode;	
	if(mode==2) {
            Complex temp=unTransform(J.X);
	    SOURCE=temp;
	}
    }




    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
	requestFocus();
    }
    public void mouseExited(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {
         MouseData J=MouseData.process(e);
	 JX=J.X;
    }

    public void mouseClicked(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}



}

