import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This console adds onto the picture canvas. It
   manages the subdivision*/


public class SubdivisionControl {
    int X;
    int Y;
    ListenSquare RANDOM;
    ListenSquare[][] S=new ListenSquare[4][4];
    ListenSquare[] T=new ListenSquare[4];
    ListenSquare[][][] U=new ListenSquare[4][3][3];
    int[] size=new int[4];
    int choice;


    public SubdivisionControl(int x,int y) {
	X=x;
	Y=y;


	RANDOM=new ListenSquare(X+5,Y+183,50,25);
	S[0][0]=new ListenSquare(X,Y+155,15,15);
	S[0][1]=new ListenSquare(X+15,Y+155,15,15);
	S[0][2]=new ListenSquare(X,Y,0,0);
	S[0][3]=new ListenSquare(X,Y,0,0);
	for(int i=0;i<4;++i) size[i]=3;


	T[0]=new ListenSquare(X+40,Y+155,20,15);

	for(int j=1;j<4;++j) {
	    S[j][2]=new ListenSquare(X+00,155+Y-40*j+00,15,15);
	    S[j][3]=new ListenSquare(X+15,155+Y-40*j+00,15,15);
	    S[j][0]=new ListenSquare(X+15,155+Y-40*j+15,15,15);
	    S[j][1]=new ListenSquare(X+00,155+Y-40*j+15,15,15);
	    T[j]=new ListenSquare(X+40,155+Y-40*j,20,30);
	}

	for(int i=0;i<4;++i) {
	    for(int j=0;j<3;++j) {
		for(int k=0;k<3;++k) {
		    U[i][j][k]=new ListenSquare(X+7+15*j,460-55*i+15*k,15,15);
		}
	    }
	}



    }


    public void render(Graphics2D g) {  

        g.setFont(new Font("Helvetica",Font.PLAIN,11));
	g.setColor(Color.white);
	g.drawString("subdivide",X+7,Y+30);
	g.drawString("move",X+10,Y+230);

	RANDOM.render(g,new Color(100,0,255));
	g.drawString("random",X+10,Y+200);

	Color[] COL=Configuration.colors();
	for(int i=0;i<4;++i) {
	    T[i].render(g,COL[i]);
	    for(int j=0;j<4;++j) {
		S[i][j].render(g,COL[i]);
	    }
	}

	for(int i=0;i<4;++i) {
	    for(int j=0;j<3;++j) {
		for(int k=0;k<3;++k) {
		    if(i>0) U[i][j][k].render(g,COL[i]);
		    if((i==0)&&(k==0)) U[i][j][k].render(g,COL[i]);
		}
	    }
	}
    }

    public void process(Point X,PictureCanvas P) {
	subdivide(X,P);
	unsubdivide(X);
	move(X,P);
	if(RANDOM.inside(X)==1) getRandomBlock(P);
    }



    public void unsubdivide(Point X) {

	for(int i=0;i<4;++i) {
	   if(T[i].inside(X)==1) --size[i];
	   if(size[i]<-1) size[i]=-1;
	}
    }

     public void subdivide(Point X,PictureCanvas P) {
	int i0=-1;
	int j0=-1;
	for(int i=0;i<4;++i) {
	    for(int j=0;j<4;++j) {
		if(S[i][j].inside(X)==1) {
		    i0=i;j0=j;
		}
	    }
	}
	if(i0==-1) return;
	if(j0==-1) return;

	Block B=P.getBlock();
	if(i0==0) B=B.subdivide1(j0);
	if(i0!=0) B=B.subdivide0(i0,j0);
	for(int i=0;i<4;++i) {
	    size[i]=B.B[i].k;
	    P.Z[i]=new Complex(B.B[i].z);
	}
     }


    /**This moves the components of the block*/

    public void move(Point X,PictureCanvas P) {

	int i0=-1;
	int j0=0;
	int k0=0;
	for(int i=0;i<4;++i) {
	    for(int j=0;j<3;++j) {
		for(int k=0;k<3;++k) {
		  if(U[i][j][k].inside(X)==1) {
		      i0=i;
		      j0=j-1;
		      k0=k-1;
		  }
		}
	    }
	}
	if(i0==-1) return;

	double x=Math.pow(.5,size[i0])*j0;
	double y=Math.pow(.5,size[i0])*k0;
        double xx=P.Z[i0].x+x;
        double yy=P.Z[i0].y-y;
	if(i0==0) {
	    if((xx>=0)&&(xx<=4)) P.Z[i0].x=xx;
	}
	if(i0!=0) {
	    if((xx>=-2)&&(xx<=2)) P.Z[i0].x=xx;
	    if((yy>=-2)&&(yy<=2)) P.Z[i0].y=yy;
	}
    }




    /**This gets a random block*/
    public void getRandomBlock(PictureCanvas P) {
	Block X=DebugSupport.randomBlock(size);
        for(int i=0;i<4;++i)  P.Z[i]=new Complex(X.B[i].z);
    }





}



