import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors */


public class Vector {
    double[] x=new double[3];
    public Vector(){}

    /**basic constructor**/

    public Vector(double xx,double yy,double zz) {
	x[0]=xx;
	x[1]=yy;
	x[2]=zz;
    }

    /**printout**/

    public void print() {
	System.out.println(x[0]+" "+x[1]+" "+x[2]);
    }

    /**basic operations**/

    public static double  dot(Vector v,Vector w) {
	return(v.x[0]*w.x[0]+v.x[1]*w.x[1]+v.x[2]*w.x[2]);
    }


    public static Vector plus(Vector v,Vector w) {
	Vector x=new Vector();
	for(int i=0;i<3;++i) x.x[i]=v.x[i]+w.x[i];
	return(x);
    }

    public static Vector minus(Vector v,Vector w) {
	Vector x=new Vector();
	for(int i=0;i<3;++i) x.x[i]=v.x[i]-w.x[i];
	return(x);
    }

    public Vector scale(double r) {
	Vector x=new Vector();
	for(int i=0;i<3;++i) x.x[i]=r*this.x[i];
	return(x);
    }

    public static double distSquared(Vector V,Vector W) {
	Vector X=minus(V,W);
	return dot(X,X);
    }



    /**inverse stereographic projection*/
    public static Vector inverseStereo(Complex z) {
	double d=1+z.x*z.x+z.y*z.y;
	double a=2*z.x/d;
	double b=2*z.y/d;
	double c=1-2/d;
	Vector v=new Vector(a,b,c);
	return(v);
    }

}




