import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class EliminateEnergy {

    /**This class performs the floating point version
       of our energy test*/

    /**The energy of the TBP*/
    public static double TBPenergy(int[][] E) {
	double tbp=0;
	for(int i=0;i<3;++i) {
	    if(E[i][0]!=0) tbp=tbp+E[i][0]*(6*Math.pow(2,E[i][1])+3);
	}
	return tbp;
    }


    /**(1,0) means eliminate.
       When it is not eliminated the return is (0,i) 
       where is the subdivision recommendation index.
       The fudge value should be 1.*/

    public static int[] main(int[][] E,Block X) {
	int[] pass={1,0};
	double eng=0;
	double tbp=TBPenergy(E);
	double[] err=ERR(E,X);
	double target=tbp+err[0];
	boolean test=energyIsHigher(target,E,X);
	if(test==true) return pass;
	int[] fail={0,(int)(err[1])};
	return fail;
    }

    /**Here is the main energy estimate.  returns true if the min vertex
       energy minus the error (err) is less than the TBP energy.*/

    public static boolean energyIsHigher(double target,int[][] E,Block X) {
	Complex[][] Z={X.B[0].toVertices(),X.B[1].toVertices(),
		       X.B[2].toVertices(),X.B[3].toVertices()};
	for(int n=0;n<128;++n) {
	    int[] q=getString(n);
	    Complex[] W={Z[0][q[0]],Z[1][q[1]],Z[2][q[2]],Z[3][q[3]]};
	    double test=Energy.energy(E,W);
	    if(test<target) return false;
	}
	return true;
    }


    /**This gets a string in {0,1} x {0,1,2,3} x {0,1,2,3} x {0,1,2,3}*/

    public static int[] getString(int n0) {
	int a0=n0%2;
	int n1=(n0-a0)/2;
	int a1=n1%4;
	int n2=(n1-a1)/4;
	int a2=n2%4;
	int n3=(n2-a2)/4;
	int a3=n3%4;
	int[] a={a0,a1,a2,a3};
	return a;
    }






    /**Here is the main error term from the paper*/

    public static double[] ERR(int[][] E, Block X) {
	double total=0;
	double max=0;
	double test=0;
	int index=0;

	for(int i=0;i<4;++i) {
	    test=ERR(E,X,i);
	    total=total+test;
	    if(max<=test) {
		index=i;
		max=test;
	    }
	}
	double[] d={total,index};
	return(d);
    }


    public static double ERR(int[][] E, Block X,int i) {
	double total=0;
	    for(int j=0;j<5;++j) {
		if(j!=i) {
		    total=total+epsilon(E,X.B[i],X.B[j]);
		}
	    }

	return(total);
    }



    public static double epsilon(int[][] E,Box B1,Box B2) {
	double total=0;
	for(int i=0;i<3;++i) {
	    double abs=Math.abs(E[i][0]);
		if(abs>.00000001) {
                total=total+abs*epsilon(E[i][1],B1,B2);
	    }
	}
	return total;
    }

    public static double epsilon(int E,Box B1,Box B2) {
	double d2=SphericalMeasures.hullDiameterSquared(B1);
	double delta=SphericalMeasures.hullSepConstant(B1);
	double T=2+2*SphericalMeasures.dotMaxUpper(B1,B2);
	double term1=0.5*d2*E*(E-1)*Math.pow(T,E-2);
	double term2=2.0*delta*E*Math.pow(T,E-1);
	return (term1+term2);
    }


    /**This is just used for debugging purposes*/

    public static double minVertexEnergy(int[][] E,Block X) {
	double min=100000;
	Complex[][] Z={X.B[0].toVertices(),X.B[1].toVertices(),
		       X.B[2].toVertices(),X.B[3].toVertices()};
	for(int n=0;n<128;++n) {
	    int[] q=getString(n);
	    Complex[] W={Z[0][q[0]],Z[1][q[1]],Z[2][q[2]],Z[3][q[3]]};
	    double test=Energy.energy(E,W);
	    if(test<min) min=test;
	}
	return min;
    }


}


