import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class EliminateEnergyInterval {

    public static Interval TBPenergy(int[][] E) {
	int eng=0;
	for(int i=0;i<3;++i) {
	    if(E[i][0]!=0) eng=eng+E[i][0]*TBPenergy(E[i][1]);
	}
	Interval tot=Interval.fat(eng);
	return tot;
    }

    public static int TBPenergy(int k) {
	return (int)(6*Math.pow(2,k)+3);
    }

    public static int[] main(int[][] E,Block X) {
	int[] pass={1,0};
	Interval[] err=ERR(E,X);
        Interval TBP=TBPenergy(E);
	Interval target=Interval.plus(TBP,err[0]);
	boolean test=energyIsHigher(target,E,X);
	if(test==true) return pass;
	int[] fail={0,(int)(err[1].l)};
	return fail;
    }


    /**Here is the main energy estimate.  The second number is the
       subdivision recommendation*/

    public static boolean energyIsHigher(Interval target,int[][] E,Block X) {
	GaussianInteger[][] Z={X.B[0].toGaussianVertices(),
                               X.B[1].toGaussianVertices(),
		               X.B[2].toGaussianVertices(),
                               X.B[3].toGaussianVertices()};
	for(int n=0;n<128;++n) {
	    int[] q=getString(n);
	    GaussianInteger[] W={Z[0][q[0]],Z[1][q[1]],Z[2][q[2]],Z[3][q[3]]};
	    Interval test=IntervalEnergy.energy(E,W);
	    if(test.l<target.r) return false;
	}
	return true;
    }



    /**This gets a string in {0,1} x {0,1,2,3} x {0,1,2,3} x {0,1,2,3}*/

    public static int[] getString(int n0) {
	int a0=n0%2;
	int n1=(n0-a0)/2;
	int a1=n1%4;
	int n2=(n1-a1)/4;
	int a2=n2%4;
	int n3=(n2-a2)/4;
	int a3=n3%4;
	int[] a={a0,a1,a2,a3};
	return a;
    }


    /**It is a bit silly for the second coord to be
       an interval.  We are just extracting an integer here*/

    public static Interval[] ERR(int[][] E, Block X) {
	Interval total=new Interval(0.0,0.0);
	Interval max=new Interval(0.0,0.0);
	Interval test=new Interval(0.0,0.0);
	Interval index=new Interval(0,0);

	for(int i=0;i<4;++i) {
	    test=ERR(E,X,i);
	    total=Interval.plus(total,test);
	    if(max.r<test.l) index=new Interval(i,i);
	    max=Interval.max(max,test);
	}

	Interval[] d={total,index};
	return(d);
    }

    public static Interval ERR(int[][] E, Block X,int i) {
	Interval total=new Interval(0.0,0.0);
	    for(int j=0;j<5;++j) {
		if(j!=i) {
		    total=Interval.plus(total,epsilon(E,X.B[i],X.B[j]));
		}
	    }

	return(total);
    }


    public static Interval epsilon(int[][] E,Box B1,Box B2) {
	Interval tot=new Interval(0.0);
	for(int i=0;i<3;++i) {
	    if(E[i][0]!=0) {
	       Interval coeff=Interval.fat(1.0*E[i][0]);
               tot=Interval.plus(tot,Interval.times(coeff,epsilon(E[i][1],B1,B2)));
	    }
	}
	return tot;
    }



    public static Interval epsilon(int k,Box B1,Box B2) {
	Interval d=IntervalSphericalMeasures.hullDiameterSquared(B1);
	Interval delta=IntervalSphericalMeasures.hullSepConstant(B1);
	Interval TWO=new Interval(2.0,2.0);
        Interval DMU=IntervalSphericalMeasures.dotMaxUpper(B1,B2);
	Interval T=Interval.plus(TWO,Interval.times(TWO,DMU));
	Interval T1=Interval.pow(T,k-2);
	Interval T2=Interval.times(T1,T);
	Interval COEFF1=Interval.fat(k*(k-1));
	COEFF1=Interval.divide(COEFF1,TWO);
	Interval term1=Interval.times(Interval.times(COEFF1,d),T1);
	Interval COEFF2=Interval.fat(2*k);
	Interval term2=Interval.times(Interval.times(COEFF2,delta),T2);
	return Interval.plus(term1,term2);
    }



}


