import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class EliminateIrrelevant {

    /**This routine eliminates a block if it is
       irrelevant.*/

    public static boolean main(boolean special,Block X) {
	if(farFromOrigin(X,1)==true) return true;
	if(farFromOrigin(X,2)==true) return true;
	if(farFromOrigin(X,3)==true) return true;
	if((special==false)&&(X.B[1].yMin()>=0)) return true;
	if(X.B[2].yMax()<=0) return true;
	if(X.B[2].yMin()>=X.B[3].yMax()) return true;
	if(X.B[1].yMin()>=X.B[2].yMax()) return true;
	if(notCompressed(X)==true) return true;
	return false;
    }

    public static boolean farFromOrigin(Block X,int k) {
	long a1=X.B[k].xMin();
	long a2=X.B[k].xMax();
	long a3=X.B[k].yMin();
	long a4=X.B[k].yMax();
	long b=X.B[0].xMax();
	long[] a={a1,a2,a3,a4};
	for(int i=0;i<4;++i) {
	    if(a[i]<0) a[i]=-a[i];
	}
	long x=a[0];
	if(a[0]>a[1]) x=a[1];
	long y=a[2];
	if(a[2]>a[3]) y=a[3];
	if(x>=b) return true;
	if(y>=b) return true;
	return false;
    }

    /**The configuration is compressed if the quantity
       f(k)=max_j (V_k.V_i) is largest for k=4.
       It if not compressed if this fails.  */

    public static boolean notCompressed(Block X) {
	double max=lowerBound(1,X,4);
	for(int i=0;i<4;++i) {
	    double min=lowerBound(0,X,i);
	    if(max<min) return true;
	}
	return false;
    }


    public static double lowerBound(int choice,Block X,int k) {
	double min=100000;
	for(int i=0;i<5;++i) {
	    if(i!=k) {
		double test=100000;
		if(choice==0) test=SphericalMeasures.dotMinLower(X.B[i],X.B[k]);
		if(choice==1) test=SphericalMeasures.dotMaxUpper(X.B[i],X.B[k]);
		if(min>test) min=test;
	    }
	}
	return min;
    }

}

