import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This class does the basic arithmetic of Gaussian integers*/

public class GaussianInteger {
    long x,y;


    public GaussianInteger() {
        this.x=0;
        this.y=0;
    } 

    public GaussianInteger(long x0,long y0) {
       this.x=x0;
       this.y=y0;
    }

    public GaussianInteger(GaussianInteger g) {
        this.x=g.x;
        this.y=g.y;
    }

    /**This operation only makes sense when we are averaging even numbers.**/

    /**printout**/
     public void print() {
	 Long X=new Long(this.x);
	 Long Y=new Long(this.y);
	 System.out.println("Gaussian: "+X.toString()+" "+Y.toString());
    } 

/**fix*/

    public static GaussianInteger average(GaussianInteger g1,GaussianInteger g2) throws ProofException {
	GaussianInteger g=new GaussianInteger();
	g.x=(g1.x+g2.x)/2;
	g.y=(g1.y+g2.y)/2;
	if(2*g.x!=g1.x+g2.x) throw new ProofException("average fails");
	if(2*g.y!=g1.y+g2.y) throw new ProofException("average fails");
	return(g);
    }

    /**Scales up a complex number by 2^n.  the complex number is
       expected to be a dyadic rational with denominator that 
       divides 2^n*/

    public static GaussianInteger convert(Complex z,int n) {
	GaussianInteger g=new GaussianInteger();
	double x1=z.x*Math.pow(2,n);
	double y1=z.y*Math.pow(2,n);
	g.x=(long)(x1);
	g.y=(long)(y1);
	return g;
    }

}

