
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This class defines the spherical measures from chapter 3
   in the paper*/

public class IntervalSphericalMeasures {


    public static IntervalVector[] sphereVectors(Box B) {

	if(B.type==2) {
	    IntervalVector[] V=new IntervalVector[1];
	    V[0]= IntervalVector.northPole();
	    return V;
	}

	GaussianInteger[] Z=B.toGaussianVertices();
	IntervalVector[] V=new IntervalVector[Z.length];
	for(int i=0;i<Z.length;++i) V[i]=IntervalVector.inverseStereo(Z[i]);
	return(V);
    }


    /**center of mass of the spherical vertices*/

     public static IntervalVector centerOfMassSpherical(Box B) {
	IntervalVector[] V=sphereVectors(B);
	if(V.length==1) return V[0];
	Interval Z=new Interval(0.0,0.0);
	IntervalVector W=new IntervalVector(Z,Z,Z);
	for(int i=0;i<V.length;++i) W=IntervalVector.plus(W,V[i]);
	Interval L=Interval.divide(new Interval(1.0,1.0),Interval.fat(V.length));
	W=W.scale(L);
	return W;
    }


    /**This computes the square of the  max diameter of a side of
       the convex hull of the box vertices.*/

    public static Interval sideDiameterMaxSquared(Box B) {
	IntervalVector[] V=sphereVectors(B);
	Interval max=new Interval(0.0,0.0);
	if(V.length==1) return max;

	for(int i=0;i<V.length;++i) {
	    int j=(i+1)%V.length;
	    Interval test=IntervalVector.distSquared(V[i],V[j]);
	    max=Interval.max(max,test);
	}
	return max;
    }

    /**This is the square of the diameter of the convex hull of the
       vertices of the box. It is used in our energy estimate*/

    public static Interval hullDiameterSquared(Box B) {
	IntervalVector[] V=sphereVectors(B);
	Interval max=new Interval(0.0,0.0);
	if(V.length==1) return max;

	for(int i=0;i<V.length;++i) {
	    for(int j=i+1;j<V.length;++j) {
		Interval test=IntervalVector.distSquared(V[i],V[j]);
		max=Interval.max(max,test);
	    }
	}
	return max;
    }

    public static Interval crudeMeasureSquared(Box B) {
	Interval ONE=new Interval(1.0,1.0);
	Interval TWO=new Interval(2.0,2.0);
	Interval N16=new Interval(16.0,16.0);
	Interval x=Interval.rescaledLong(B.g.x);
	Interval y=Interval.rescaledLong(B.g.y);
	Interval R2=Interval.plus(Interval.times(x,x),Interval.times(y,y));
	Interval SIDE=Interval.inversePower2(B.k);
	Interval r2=Interval.times(SIDE,SIDE);
	r2=Interval.divide(r2,TWO);
	Interval a=Interval.times(N16,r2);
	Interval b=Interval.plus(ONE,Interval.times(TWO,r2));
	b=Interval.plus(b,Interval.times(r2,r2));
	b=Interval.plus(b,Interval.times(TWO,R2));
	b=Interval.minus(b,Interval.times(TWO,Interval.times(r2,R2)));
	b=Interval.plus(b,Interval.times(R2,R2));
	Interval diam2=Interval.divide(a,b);
	return diam2;
    }

    public static Interval hullSepConstant(Box B) {
	if(B.type==2) return new Interval(0.0,0.0);
        Interval crude=crudeMeasureSquared(B);
	Interval c2=circleBound2(crude);
	if(B.type==1) return c2;
	Interval side=sideDiameterMaxSquared(B);
	Interval c1=circleBound1(side);
	Interval c=Interval.max(c1,c2);
	return(c);
    }


     public static Interval circleBound1(Interval d) {
	 Interval A2=new Interval(2.0,2.0);
	 Interval A4=new Interval(4.0,4.0);
	 Interval x1=Interval.divide(d,A4);
	 Interval x2=Interval.divide(Interval.times(d,d),A2);
	 return Interval.plus(x1,x2);
     }



     public static Interval circleBound2(Interval d) {
	 Interval A8=new Interval(8.0,8.0);
	 Interval A16=new Interval(16.0,16.0);
	 Interval x1=Interval.divide(d,A8);
	 Interval x2=Interval.divide(Interval.times(d,d),A16);
	 return Interval.plus(x1,x2);
     }


    public static Interval dotMinLower(Box B1,Box B2) {
	IntervalVector[] V1=sphereVectors(B1);
	IntervalVector[] V2=sphereVectors(B2);
	Interval min=new Interval(2.0,2.0);
	for(int i=0;i<V1.length;++i) {
	    for(int j=0;j<V2.length;++j) {
		Interval test=IntervalVector.dot(V1[i],V2[j]);
		min=Interval.min(min,test);
	    }
	}
        if(B1.type==2) return min;
	if(B2.type==2) return min;
	Interval d1=hullSepConstant(B1);
	Interval d2=hullSepConstant(B2);
	Interval d12=Interval.times(d1,d2);
	Interval d3=Interval.plus(d1,d2);
	d3=Interval.plus(d3,d12);
	min=Interval.minus(min,d3);
	return min;
    }


    public static Interval dotMaxUpper(Box B1,Box B2) {
	IntervalVector[] V1=sphereVectors(B1);
	IntervalVector[] V2=sphereVectors(B2);
	Interval max=new Interval(-2.0,-2.0);
	for(int i=0;i<V1.length;++i) {
	    for(int j=0;j<V2.length;++j) {
		Interval test=IntervalVector.dot(V1[i],V2[j]);
		max=Interval.max(max,test);
	    }
	}
        if(B1.type==2) return max;
	if(B2.type==2) return max;
	Interval d1=hullSepConstant(B1);
	Interval d2=hullSepConstant(B2);
	Interval d12=Interval.times(d1,d2);
	Interval d3=Interval.plus(d1,d2);
	d3=Interval.plus(d3,d12);
	max=Interval.plus(d3,max);
	return max;
    }








}
