import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This class does the basic interval arithmetic of vectors */

public class IntervalVector {
    Interval[] x=new Interval[3];
    
    /**constructors **/

    public IntervalVector() {}

    public IntervalVector(Interval xx,Interval yy,Interval zz) {
	x[0]=new Interval(xx);
	x[1]=new Interval(yy);
	x[2]=new Interval(zz);
    }

    /**printout**/
     public void print() {
	 for(int i=0;i<3;++i) {
	     System.out.print("["+x[i].l+" , "+x[i].r+"] ");
	 }
	System.out.println();
    } 

    /**The special vector**/

    public static IntervalVector northPole() {
	IntervalVector V=new IntervalVector(new Interval(0.0),new Interval(0.0),new Interval(1.0));
	return(V);
    }

    /**basic operations**/

    public static Interval  dot(IntervalVector v,IntervalVector w) {
	Interval I=new Interval(0.0,0.0);
	for(int i=0;i<3;++i) I=Interval.plus(I,Interval.times(v.x[i],w.x[i]));
	return(I);
    }

    public static IntervalVector plus(IntervalVector v,IntervalVector w) {
	IntervalVector X=new IntervalVector();
	for(int i=0;i<3;++i) {
	    X.x[i]=Interval.plus(v.x[i],w.x[i]);
	}
	return(X);
    }

    public static IntervalVector minus(IntervalVector v,IntervalVector w) {
	IntervalVector X=new IntervalVector();
	for(int i=0;i<3;++i) {
	    X.x[i]=Interval.minus(v.x[i],w.x[i]);
	}
	return(X);
    }

    public IntervalVector scale(Interval I) {
	IntervalVector V=new IntervalVector();
	for(int i=0;i<3;++i) V.x[i]=Interval.times(I,x[i]);
	return(V);
    }

    public static Interval distSquared(IntervalVector v,IntervalVector w) {
	IntervalVector X=minus(v,w);
	Interval D=dot(X,X);
	return(D);
    }


    /**This routine does inverse stereographic projection to a
       Gaussian integer. It first scales the integer down by
       2^{-25}**/


    public static IntervalVector inverseStereo(GaussianInteger g) {
	Interval ONE=new Interval(1.0,1.0);
	Interval TWO=new Interval(2.0,2.0);
	Interval x=Interval.rescaledLong(g.x);
	Interval y=Interval.rescaledLong(g.y);
	Interval d=Interval.plus(ONE,Interval.times(x,x));
	d=Interval.plus(d,Interval.times(y,y));
	Interval a=Interval.divide(Interval.times(TWO,x),d);
	Interval b=Interval.divide(Interval.times(TWO,y),d);
	Interval c=Interval.minus(ONE,Interval.divide(TWO,d));
	IntervalVector v=new IntervalVector(a,b,c);
	return(v);
    }







}

