import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This contains the main test routin, main.  The rest
   of the file has to do with the mechanics of doing
   the divide and conquer algorithm*/
   

public class Proof {
    boolean HALT;
    Block[] LIST=new Block[300];
    long PASSED,TIME;
    double TOTAL;
    int CHOICE,MODE,COUNT;
    int[] LOG=new int[300];
    boolean PRINT;

    /**This is the construction method for the program*/

    public Proof() {
	TIME=System.currentTimeMillis();
	HALT=true;
	COUNT=1;
	TOTAL=0;
	PASSED=0;
        LIST[0]=Block.initialBox();
	for(int i=0;i<200;++i) LOG[i]=0;
	PRINT=true; //for printing out the program status		
    }


    /**Here is the runnable routine.
       choice = 0,1,2,3,4,5 tells you which energy combo to test.
       mode = 0,1 tells you whether to do the floating point
       test or the interval test.*/


    public void main(int choice,int mode) {
	CHOICE=choice;
	MODE=mode;	
        HALT=false;
	printStatus();
	int[][] E=EnergyPresets.main(0);
	int[] elim={1,1,1,0};
	if(choice==5) elim[3]=1;   //puts in the SMALL elimination

 	while((HALT==false)&&(COUNT>0)) {
	    mainStep(mode,elim,E);
	}
	printStatus();
	HALT=true;
    }


    /**The main step in the algorithm.*/

    public void mainStep(int mode,int[] elim,int[][] E) {   
 	 int[] test={0,0};
         Block X=new Block(LIST[COUNT-1]);
	 boolean rigor=false;
	 if(mode==1) rigor=true;
	 test=ProofGrading.main(rigor,elim,E,X);
	 if(test[0]==0)  subdivide(X,test[1]);
	 if(test[0]==1)  eliminate(X);  
    }




    /** elimination: we display the eliminated block
        on the picture window*/

    public void eliminate(Block X) {
	--COUNT;
	++LOG[14+X.volumeLog()];  
	++PASSED;
	long t=System.currentTimeMillis()-TIME;
	if(t%1000==1) PRINT=true;
	if((PRINT==true)&&(t%1000==0))	printStatus();
    }

    /**Subdivision: The integer q tells which subdivision to perform.**/

    public void  subdivide(Block X,int q) {
	--COUNT;
	if(q==0) {
	   for(int n=0;n<2;++n) {
	      LIST[COUNT]=X.subdivide1(n);
	      ++COUNT;
	   }
	}

	if(q!=0) {
	  for(int n=0;n<4;++n) {
	  LIST[COUNT]=X.subdivide0(q,n);
	  ++COUNT;
	  }
	}
    }

    /**Computes the volume of the passed blocks. 
       The total volume is 1*/

    public void computeVolume() {
         double total=0;
	 for(int i=0;i<200;++i) {
	   total=total+LOG[i]*Math.pow(.5,i);
	 } 
         TOTAL=total;
    }

    /**This prints the program status to the command line*/
    public void printStatus() {	
        computeVolume();
	if(CHOICE==0) System.out.print("G3");
	if(CHOICE==1) System.out.print("G4");
	if(CHOICE==2) System.out.print("G5_flat");
	if(CHOICE==3) System.out.print("G6");
	if(CHOICE==4) System.out.print("G10_sharpsharp");
	if(CHOICE==5) System.out.print("G10_sharp");
	if(MODE==0) System.out.print(" float ");
	if(MODE==1) System.out.print(" interval ");
	System.out.print("volume "+TOTAL);
        System.out.print(" partition size "+PASSED);
	long t=System.currentTimeMillis()-TIME;
	String S=Time.convert(t);
	System.out.println(" "+S);
	PRINT=false;
    }



}


