
public class ProofGrading {

    /**The exact ordering is deliberate. This does the main test to a
       Block X, to see if we can eliminate it.  Here is a guide to the
       arguments:

       rigor: false specifies the floating point test and true specifies 
       the interval arithmetic test.

       elim:  This specifies which tests to apply.  In all cases except
       for the energy G10_sharpsharp we do the first 3 tests. For 
       G10_sharpsharp, we do the last one as well. The last one pertains
       to the set SMALL.

       E: this is the energy combo.

       X: This is the block.*/


    public static int[] main(boolean rigor,int[] elim,int[][] E,Block X) {
	boolean special=isSpecial(E);
	if(tooSmall(X)==true) finalFail(X);
        int[] pass={1,0};
	int s=sideTooLong(X);if(s!=-1) return fail(s);

	if(elim[0]==1) {
	    if(EliminateIrrelevant.main(special,X)==true) return pass;
	}

	if(elim[1]==1) {
	   if(EliminateFarOut.main(X)==true) return pass;
	}

	if(elim[2]==1) {
	   if(EliminateNearTBP.main(X)==true) return pass;
	}

	if(elim[3]==1) {
	   if(EliminateInsideSmall.main(X)==true) return pass;
	}

	int[] floating_version=EliminateEnergy.main(E,X);
	if(rigor==false) return floating_version;
	if(floating_version[0]==0) return floating_version;
	int[] interval_version= EliminateEnergyInterval.main(E,X);  
	return interval_version;
    }

    /**This is invoked if the routine fails*/
    public static void finalFail(Block X) { 
        X.print();
        throw new ProofException("too many subdivisions");
    }

    /**tests if a side is too long for us to have a
       clean dyadic block in the sense of Chapter 3 in the
       monograph*/

    public static int sideTooLong(Block X) {
	for(int i=1;i<4;++i) {
            if(X.B[i].k<1) return(i);
	}
	return -1;
    }

    /**This just formats the data when the block fails the test.
       The first term in the sequence (0) denotes failure and
       the second term denotes the subdivision recommendation.
       The first term would be 1 in case of a pass*/

    public static int[] fail(int i) {
	int[] f={0,i};
	return f;
    }

    /**In this situation the dyadic box is too small, meaning
       that it has undergone too many subdivisions. If this
       is ever true, the program halts with failure*/

    public static boolean tooSmall(Block X) {
	for(int i=0;i<4;++i) {
	    if(X.B[i].k>=Box.SCALE-1) return true;
	}
	return false;
    }	

    /**This is true when we run a power combo with some
       negative coefficients. In practice we only have this
       for E5_flat*/

    public static boolean isSpecial(int[][] E) {
        boolean special=false;
	for(int i=0;i<3;++i) {
	    if(E[i][0]<0) special=true;
	}
	return special;
    }

}


