import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is our class which does arbitrary size
   calculations with rational numbers.  the rational
   is P/Q, where P and Q are BigIntegers*/

public class BigRational {
    BigInteger P;
    BigInteger Q;

    public BigRational() {}


    /**Here are the ways to construct BigRationals:*/

    /**From a pair of Big integers*/
    public BigRational(BigInteger P0,BigInteger Q0) {
	P=new BigInteger(P0.toString());
	Q=new BigInteger(Q0.toString());
    }

    /**From a pair of longs*/
    public BigRational(long p,long q) {
	Long pp=new Long(p);
	Long qq=new Long(q);
	P=new BigInteger(pp.toString());
	Q=new BigInteger(qq.toString());
	this.reduce();
    }

    /**From a BigRational. This just copies the BigRational*/
    public BigRational(BigRational R) {
	P=new BigInteger(R.P.toString());
	Q=new BigInteger(R.Q.toString());
    }

    /**From a pair of strings. This is useful if we want to
       specify a very complicated BigRational*/

    public BigRational(String p,String q) {
	P=new BigInteger(p);
	Q=new BigInteger(q);
    }


    /** reduces to lowest terms*/

    public void reduce() {
	BigInteger C=P.gcd(Q);
	P=P.divide(C);
	Q=Q.divide(C);
    }

    /**Here are the basic arithmetic operations*/

    public BigRational add(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.Q);
	Y.P=Y.P.add(Q.multiply(X.P));
	Y.reduce();
	return(Y);
    }

    public BigRational subtract(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.Q);
	Y.P=Y.P.subtract(Q.multiply(X.P));
	Y.reduce();
	return(Y);
    }

    public BigRational multiply(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.Q);
	Y.P=P.multiply(X.P);
	Y.reduce();
	return(Y);
    }
    public BigRational divide(BigRational X) {
	BigRational Y=new BigRational();
	Y.Q=Q.multiply(X.P);
	Y.P=P.multiply(X.Q);
	Y.reduce();
	return(Y);
    }

    /**Comparison operations*/
    public boolean isZero() {
	if(P.signum()==0) return true;
	return false;
    }

    public boolean isPositive() {
	int a=P.signum()*Q.signum();
	if(a==1) return true;
	return false;
    }

    public boolean isNegative() {
	int a=P.signum()*Q.signum();
	if(a==-1) return true;
	return false;
    }

    /**Here is our power function tester. This returns 
       -1 if X<A^E 
        0 if X=A^E
        1 if X>A^E*/

    public static int testPow(BigRational A,BigRational E,BigRational X) {
	BigInteger a=A.P;
	BigInteger b=A.Q;
	BigInteger c=X.P;
	BigInteger d=X.Q;
	BigInteger pp=E.P;
	BigInteger qq=E.Q;
	int p=pp.intValue();
	int q=qq.intValue();
	a=a.pow(p);
	b=b.pow(p);
	c=c.pow(q);
	d=d.pow(q);
	BigInteger ad=a.multiply(d);
	BigInteger bc=b.multiply(c);
	BigInteger test=bc.subtract(ad);
	return test.signum();
    }


    /**conversion to other types*/

    public double toDouble() {
	BigDecimal c=this.toBigDecimal(30);
	return c.doubleValue();
    }

    public BigDecimal toBigDecimal(int k) {
	BigDecimal X=new BigDecimal(P);
	BigDecimal Y=new BigDecimal(Q);
	X=X.divide(Y,k,BigDecimal.ROUND_HALF_DOWN);
	return(X);
    }

    /**Printouts*/

    public void print() {
	System.out.print(P.toString()+"/"+Q.toString());
    }

    public void println() {
	System.out.println(P.toString()+"/"+Q.toString());
    }

    public void printlnN() {
	BigDecimal D=this.toBigDecimal(30);
	String S=D.toString();
	System.out.println(S);
    }

}


    

