import java.awt.*;
import java.awt.geom.*;

/**This is the basic object for the subdivision alg.
The corners of the square are (x0,y0) and (x1,y1).
The two parameters (exponents) are s1 and s2
The longs are 2^{16} times the box coordinates*/

public class Box {
    long X0,Y0,X1,Y1;
    long S0,S1;
    int age1,age2;
    int type;


    public Box() {}

    /**constructor*/
    public Box(long XX0,long YY0,long XX1,long YY1,long SS0,long SS1) {
	X0=XX0;
	X1=XX1;
	Y0=YY0;
	Y1=YY1;
	S0=SS0;
	S1=SS1;
    }

    /**This is the big box which comprises the entire
       space*/

    public static Box initial() {
	long t=65536;
	Box B=new Box(0,0,t,t,0,16*t);
	B.age1=0;
	B.age2=-4;
	return B;
    }


    /**This one subdivides in the spatial directions and
       ignores the parameter direction.*/

    public Box sub1(int i,int j) {
	Box B=new Box();
	long X2=(X0+X1)/2;
	long Y2=(Y0+Y1)/2;
	long XX0,YY0,XX1,YY1;
	XX0=X0;
	XX1=X2;
	YY0=Y0;
	YY1=Y2;

	if(i==1) {
	    XX0=X2;
	    XX1=X1;
	}

	if(j==1) {
	    YY0=Y2;
	    YY1=Y1;
	}
	B=new Box(XX0,YY0,XX1,YY1,S0,S1);
	B.age1=age1+1;
	B.age2=age2;
	return B;
    }


    /**This one subdivides in the parameter direction 
       and ignores the spatial directions.*/

    public Box sub2(int k) {
	Box B=new Box();
	 long S2=(S0+S1)/2;
	 long SS0,SS1;
	SS0=S0;
	SS1=S2;

	if(k==1) {
	    SS0=S2;
	    SS1=S1;
	}
	B=new Box(X0,Y0,X1,Y1,SS0,SS1);	
        B.age1=age1;
	B.age2=age2+1;
	return B;
    }




    /**Tests if the given box is contained in Box B*/

    public boolean inside(Box B) {
	if(X0<B.X0) return false;
	if(Y0<B.Y0) return false;
	if(X1>B.X1) return false;
	if(Y1>B.Y1) return false;
	if(S0<B.S0) return false;
	if(S1>B.S1) return false;
	return true;
    }

    /**Convert the box to a path which we can draw*/

    public Path2D.Double toPath() {
	Path2D.Double gp=new Path2D.Double();
	double big=65536.0;
	double x0=X0/big;
	double x1=X1/big;
	double y0=Y0/big;
	double y1=Y1/big;
	gp.moveTo(x0,y0);
	gp.lineTo(x0,y1);
	gp.lineTo(x1,y1);
	gp.lineTo(x1,y0);
	gp.closePath();
	return gp;
    }

    /**Printout*/

    public void print() {
	System.out.println("corner 0:  "+X0+" "+Y0);
	System.out.println("corner 1:  "+X1+" "+Y1);
	System.out.println("exp range: "+S0+" "+S1);
    }


}

