import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This is the control panel*/

public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    ListenSquare GO,STOP,CLEAR;
    ControlPanel TEST,SLICE,DISPLAY;
    Proof1 PR1;                   //a runnable console
    Proof2 PR2;                 //a runnable console
    HSlider S0,S1,S2;
    Box[] B=new Box[100000];  //the plotted boxes
    int count=0;
    String[] MESSAGE=new String[5];

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(20,660,510);
	 GO=new ListenSquare(0,82,30,20);
	 STOP=new ListenSquare(32,82,35,20);
	 CLEAR=new ListenSquare(69,82,41,20);
	 PR1=new Proof1();
	 PR2=new Proof2();
	 Color[] C={new Color(30,30,50),Color.white,new Color(150,0,200)};
	 S0=new HSlider(0,157,590,20,300,C,"parameter slice");
	 S1=new HSlider(0,132,590,20,300,C,"slice near critical");
	 S2=new HSlider(0,107,590,20,300,C,"slice very near critical");
	 setControls();
	 for(int i=0;i<5;++i) MESSAGE[i]="";
     }


    public void setControls() {
      Color[] C0={new Color(80,160,255),Color.white,
      Color.white,Color.black,Color.red};
      String[] TestString={"Ch 17: float","Ch 17: int","Ch 18","debug","test"};
      int[] TestState={1,0,0,0};
      TEST=new ControlPanel(C0,TestString,TestState,4);
      TEST.mode=0;
      String[] SliceString={"static","dynamic","slice motion"};
      int[] SliceState={0,1};
      SLICE=new ControlPanel(C0,SliceString,SliceState,2);
      SLICE.mode=1;
      String[] DisplayString={"foliation","export","extras"};
      int[] DisplayState={0,0};
      DISPLAY=new ControlPanel(C0,DisplayString,DisplayState,2);
      DISPLAY.mode=1;
    }

    /**This is the main drawing routine.*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2; 
      drawControls(g);
      drawMessage(g);
   }

    public void drawControls(Graphics2D g) {
	g.setColor(new Color(0,0,50));
	g.fillRect(0,0,getWidth(),getHeight());
	if((PR1.HALT==true)&&(PR2.HALT==true)) {
            GO.render(g,new Color(0,160,0));
	    g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
	}
	STOP.render(g,new Color(200,0,0));
	g.drawString("stop",(int)(STOP.x+4),(int)(STOP.y+15));
	CLEAR.render(g,new Color(0,0,250));
	g.drawString("clear",(int)(CLEAR.x+5),(int)(CLEAR.y+15));
	TEST.render(g,0,0,110);
	SLICE.render(g,115,0,75);
	DISPLAY.render2(g,115,55,75);
	S0.render(g);
	S1.render(g);
	S2.render(g);
	double d=getParameter();
	Double D=new Double(d);
	g.setColor(Color.white);
	g.drawString(D.toString(),200,172);
    }

    public void drawMessage(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.setColor(Color.white);
	for(int i=0;i<5;++i) 
	    g.drawString(MESSAGE[i],200,20+20*i);
    }





    /**Here are the routines for modifying and getting the parameter*/

    public void modifyParameter(Point X) {
	S0.modify(X);
	S1.modify(X);
	S2.modify(X);

	if(S1.inside(X)==1) {
	    double d=convert(15,15+25.0/512,S1.getValue());
	    setParameter(0,d);
	}

	if(S2.inside(X)==1) {
	    double d1=convert(15+23.0/512,15+25.0/512,S2.getValue());
	    double d2=unConvert(15,15+25.0/512,d1);
	    double d=convert(15,15+25.0/512,d2);
	    setParameter(1,d1);
	    setParameter(0,d);
	}
    }

    public void setParameter(double d) {
	for(int k=0;k<3;++k) setParameter(k,d);
    }

    public void setParameter(int k, double d) {
	double p=0;
        if(k==0) p=unConvert(12,16,d);
        if(k==1) p=unConvert(15,15+25.0/512,d);
        if(k==2) p=unConvert(15+23.0/512,15+25.0/512,d);
	if(p<0) p=0;
	if(p>1) p=1;
        if(k==0) S0.pos=S0.x+p*S0.w;
        if(k==1) S1.pos=S1.x+p*S1.w;
        if(k==2) S2.pos=S2.x+p*S2.w;
    }

    public double getParameter() {
	return convert(12,16,S0.getValue());
    }

    public static double convert(double a,double b,double d0) {	
	double d=(1-d0)*a+d0*b;
       return d;
    }

    public static double unConvert(double a,double b,double d) {	
       double d0=(d-a)/(b-a);
       return d0;
    }

    /**Done with parameter routines*/


    /**Launching the calculations*/

    public void doGo() {
	if(PR1.HALT==false) return;
	if(PR2.HALT==false) return;
	if(TEST.mode<=1) {
	   count=0;
	   PR1=new Proof1(M);
	   new Thread(PR1).start();
	}

	if(TEST.mode==2) {
	   count=0;
	   PR2=new Proof2(M);
	   new Thread(PR2).start();
	}

	if(TEST.mode==3) Debugger.main(this.M);
    }



    /**Mouse events*/
    public void mousePressed(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}  
 
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
       	if(GO.inside(J.X)==1) doGo();
	if(STOP.inside(J.X)==1) PR1.HALT=true;
	if(STOP.inside(J.X)==1) PR2.HALT=true;
	if(CLEAR.inside(J.X)==1) M.P.count=0;
	int test=TEST.switchMode(J.X);
	if(test==20) DocumentControl.action(this.M.D);
	test=SLICE.switchMode(J.X);
	if(test==20) DocumentControl.motion(this.M.D);
	test=DISPLAY.toggle(J.X);
	if(test==20) DocumentControl.display(this.M.D);
	modifyParameter(J.X);
	M.repaint();
     }

    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	modifyParameter(J.X);
	M.repaint();
    }




}



