import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This class does the main debugging operation.
   This compares the floating point and BigRational
   definitions of the energy to each other*/

public class Debugger {

    public static void main(Manager M) {
	long X=randomXY();
	long Y=randomXY();
	long S=randomExponent();

	double big=65536.0;
	double x=X/big;
	double y=Y/big;
	double s=S/big;

	M.C.MESSAGE[0]="debugger";

	Long XX=new Long(X);
	Long YY=new Long(Y);
	Long SS=new Long(S);
	M.C.MESSAGE[1]="unscaled "+XX.toString()+" "+YY.toString()+"   "+SS.toString();

	Double x0=new Double(x);
	Double y0=new Double(y);
	Double s0=new Double(s);

	M.C.MESSAGE[2]=x0.toString()+" "+y0.toString()+"   "+s0.toString();

	BigRational Z=Energy.R(-1,S,X,Y);
	double z=EnergyFloat.R(S,X,Y);
	BigDecimal Z0=Z.toBigDecimal(14);
	Double z0=new Double(z);
	M.C.MESSAGE[3]="R function: "+Z0.toString()+"   "+z0.toString();

	Z=Energy.H(-1,S,X,Y);
	z=EnergyFloat.H(S,X,Y);
	Z0=Z.toBigDecimal(14);
	z0=new Double(z);
	M.C.MESSAGE[4]="H function: "+Z0.toString()+"   "+z0.toString();

	M.C.setParameter(s);
	M.repaint();


    }

    /**This gets random point values in the range [.5,1]^2.
       We stay away from 0 just because the terms are huge*/

    public static long randomXY() {
	long y=32768+(long)(32768*Math.random());
	return y;
    }

    /**This gets exponents between 12 and 16, but only
       with small denominator: 12 + a/64, a=0,...,255.
       We could test exponents with larger denominator,
       but it would take longer to run*/

    public static long randomExponent() {
	int x0=(int)(256*Math.random());
	double x1=1.0*x0/64;   //between 0 and 4
	double x2=(12+x1)*65536;
	long y=(long)(x2);
	return y;
    }


}


