import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void action(DocumentCanvas D) {
	String S="test mode";
	S=S+"\n\nThere are 4 main modes for this program.  You select one of the 4 modes and then press the green button.  If you want to stop the calculation, you press the red button. ";
	S=S+"\n\n1. Ch 17 float:  This does the floating point version of the calculation from Chapter 17.  This is very fast.  Once the calculation is done, you should use the sliders to prove the partition produced.";

	S=S+"\n\n2. Ch 17 int:  This does the integer version of the calculations.  This is much slower.  It takes about 3 minutes.  It is fun to watch, though, if you keep the slice motion on the dynamic mode. You can zoom into the picture around the critical region to see more of the action.  As the program runs, you will see blue squares produced and red squares produced. The red squares are outside the bounds of the calculation for one reason or another.  They are irrelevant.";

	S=S+"\n\n3. Ch 18: This launches the short calculation of 17x17 points from Chapter 18. When you push this button, the control panel will display a brief record of the calculations as they are done. The output looks like\n\ni j: x\n\nwhere i and j are the indices of the calculation and x is a decimal approximation to the output of the calculation. Here n should be positive in all cases.  The program is set to fail if x is ever less than 0 but this does not happen.  The display ends when the program is done.";

	S=S+"\n\n4. debug. This checks that the floating point definitions of the main functions agree to high precision with the BigRational versions.  The BigRational versions, which are used in the formal proof, are rather hard to read.  the floating point routines are much easier to read.  The fact that the two versions match is very strong evidence that we have correctly programmed the BigRational versions.";

	sendTo(D,S);
    }



    public static void motion(DocumentCanvas D) {
	String S="slicer motion";
	S=S+"\n\nThis controls how the display works as the divide and conquer algorithm is run.  In the static mode, the slice does not change as boxes are added to the partition.  In the dynamic more, the slice is moved to the center of the most current box.  For the floating point calculations, this is too fast to see. For the integer calculations the dynamic feature works very nicely.";
        sendTo(D,S);
    }


    public static void display(DocumentCanvas D) {
	String S="display";
	S=S+"\n\nThis controls two additional things.  The top button lets you see or hide the small foliation by parabolas that is used for the parabolic retraction in Chapter 18. You can see that these curves are practically straight line segments.  The bottom bottm lets you export pictures. I used this feature to illustrate Chapter 17 of the monograph.";
        sendTo(D,S);
    }


}


