import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="Endgame Calculations\n\n";

	S=S+"This program is a companion to my monograph.  It does the main calculations for Part 5 of the monograph, the Endgame.  There are two main calculations, the one described in Chapter 17 and the one described in Chapter 18.   The one described in Chapter 18 is quite simple and does not have a good graphical user interface.  The calculation from Chapter 17 is the main one.";

	    S=S+"\n\nThis window gives explanations for the rest of the program.  Drag the mouse over the text to scroll up or down. (There is more text than what is now visible.) The text in this window will change if you press some of the black ?-boxes sprinkled throughout the rest of the program. If you want to return this text, press the black ?-box at top left.";

	    S=S+"\n\nWhen this program opens, it shows three windows, this one, a control panel, and a picture window.  You launch the tests from the control panel.  The green button is the green go button and the red button is the stop button.  You can run the calculation from Chapter 17 either using floating point calculations or using exact integer calculations. The floating point calculations, while not rigorous, are much faster than the integer calculations and do almost the same thing.";

	    S=S+"\n\nHere is some discussion of the calculation from Chapter 17.  This does a divide and conquer algorithm on a domain which is a 3D rectangular solid.  When you are done with the calculation you have a partition of this solid into smaller rectangular solids.  We called these dyadic boxes in the monograph.  Using the slider you can slice through the rectangle solid and see the picture at any slice.";

	    S=S+"\n\nThere are 3 sliders in all. The bottom one lets you move through the solid in the range [12,16].  The middle one focuses on the slices near the critical value. The top one focuses even more narrowly around the critical value.  The best way to get a sense of what is going on is to run the floating point calculations and then see what the different sliders do to the picture.";

	    S=S+"\n\nOne thing to note is that actually the algorithm produces a partition of a much larger rectangular solid, [0,16] x [0,1] x [0,1]. However, everything outside the region discussed in the monograph is passed in a more or less trivial way.  Our sliders only let you explore the region [13,16] x [0,1] x [0,1].  Here 13 is the lower cutoff for the results.";

	    S=S+"\n\nIf you have a 3 button mouse, you can zoom in and out of the picture using left and right mouse clicks.  If you don't have a 3-button mouse, you can zoom using the keys z,x or b,m.  The scaling is a bit touchy with the keyboard. If it doesn't work, first click any mouse click on the window.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

