import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;


public class Energy {

    /**The routines in this class are the BigRational routines
       in the class EnergyFloat.java.  The Debugger checks that
       the complicated routines here agree with the simpler
       routines there.*/



    /**Here is the main routine. 
       -1 gives an underapproximation
       +1 gives an overapproximation.
        We are computing the Riesz s-energy at the point
        (X/65536,Y/65536)
         using the exponent
        s=S/65536.  
    */

    public static  BigRational R(int sign,long S,long X,long Y) {
	BigRational t1=A(sign,S,X);
	BigRational t2=A(sign,S,Y);
	BigRational t3=C(sign,S,X,Y);
	BigRational t4=B(sign,S,X);
	BigRational t5=B(sign,S,Y);
	BigRational t=new BigRational(0,1);
	t=t.add(t1);
	t=t.add(t2);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t4);
	t=t.add(t4);
	t=t.add(t5);
	t=t.add(t5);
	return t;
    }


    /**Here are the component functions which go into the final
       calculation of the energy.  Again, the exponent is
       given by s=S/65536.   We take (S/65536)/2=S/131072 so
       as to match the fact that we the function calls for
       s/2 rather than s.  See the formulas in the 
       EnergyFloat class.  The debugger checks that
       this is the correct thing to do.*/

    public static  BigRational A(int sign,long S,long X) {
	BigRational s=new BigRational(S,131072);
	BigRational R=pow(sign,a(X),s);
	return R;
    }

    public static  BigRational B(int sign,long S,long X) {
	BigRational s=new BigRational(S,131072);
	BigRational R=pow(sign,b(X),s);
	return R;
    }

    public static  BigRational C(int sign,long S,long X,long Y) {
	BigRational s=new BigRational(S,131072);
	BigRational R=pow(sign,c(X,Y),s);
	return R;
    }


    public static  BigRational a(long X) {
	BigRational BX=new BigRational(X,65536);
	BigRational ONE=new BigRational(1,1);
	BigRational A=ONE.add(BX.multiply(BX));
	A=A.multiply(A);
	A=A.divide(BX);
	A=A.divide(BX);
	A=A.multiply(new BigRational(1,16));
	return A;
    }

    public static  BigRational b(long X) {
	BigRational BX=new BigRational(X,65536);
	BigRational ONE=new BigRational(1,1);
	BigRational A=ONE.add(BX.multiply(BX));
	A=A.multiply(new BigRational(1,4));
	return A;
    }

    public static  BigRational c(long X,long Y) {
	BigRational BX=new BigRational(X,65536);
	BigRational BY=new BigRational(Y,65536);
	BigRational ONE=new BigRational(1,1);
	BigRational A=ONE.add(BX.multiply(BX));
	BigRational B=ONE.add(BY.multiply(BY));
	A=A.multiply(B);
	BigRational C=BX.multiply(BX);
	C=C.add(BY.multiply(BY));
	A=A.divide(C);
	A=A.multiply(new BigRational(1,4));
	return A;
    }

    /**This ends the list of functions defining the Riesz-s energy. 
       Now we start computing the long list of partial derivatives
       of the Riesz s-energy.*/

    public static  BigRational Ax(int sign,long S,long X) {
	BigRational a=a(X);
	BigRational ax=ax(X);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational R=E.multiply(pow(sign,a,E1));
	R=R.multiply(ax);
	return R;
    }

    public static  BigRational Bx(int sign,long S,long X) {
	BigRational b=b(X);
	BigRational bx=bx(X);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational R=E.multiply(pow(sign,b,E1));
	R=R.multiply(bx);
	return R;
    }

    public static  BigRational Cx(int sign,long S,long X,long Y) {
	BigRational c=c(X,Y);
	BigRational cx=cx(X,Y);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational R=E.multiply(pow(sign,c,E1));
	R=R.multiply(cx);
	return R;
    }

    public static  BigRational Cy(int sign,long S,long X,long Y) {
	BigRational c=c(X,Y);
	BigRational cx=cy(X,Y);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational R=E.multiply(pow(sign,c,E1));
	R=R.multiply(cx);
	return R;
    }

    public static  BigRational Rx(int sign,long S,long X,long Y) {
	BigRational t1=Ax(sign,S,X);
	BigRational t2=Bx(sign,S,X);
	BigRational t3=Cx(sign,S,X,Y);
	BigRational t=new BigRational(0,1);
	t=t.add(t1);
	t=t.add(t2);
	t=t.add(t2);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	return t;
    }

    public static  BigRational Ry(int sign,long S,long X,long Y) {
	BigRational t1=Ax(sign,S,Y);
	BigRational t2=Bx(sign,S,Y);
	BigRational t3=Cy(sign,S,X,Y);
	BigRational t=new BigRational(0,1);
	t=t.add(t1);
	t=t.add(t2);
	t=t.add(t2);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	return t;
    }

    public static  BigRational Axx(int sign,long S,long X) {
	BigRational a=a(X);
	BigRational ax=ax(X);
	BigRational axx=axx(X);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational E2=E.subtract(new BigRational(2,1));
	BigRational R1=E.multiply(E1.multiply(pow(sign,a,E2)));
	BigRational R2=E.multiply(pow(sign,a,E1));
	R1=R1.multiply(ax.multiply(ax));
	R2=R2.multiply(axx);
	return R1.add(R2);
    }

    public static  BigRational Bxx(int sign,long S,long X) {
	BigRational b=b(X);
	BigRational bx=bx(X);
	BigRational bxx=bxx(X);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational E2=E.subtract(new BigRational(2,1));
	BigRational R1=E.multiply(E1.multiply(pow(sign,b,E2)));
	BigRational R2=E.multiply(pow(sign,b,E1));
	R1=R1.multiply(bx.multiply(bx));
	R2=R2.multiply(bxx);
	return R1.add(R2);
    }

    public static  BigRational Cxx(int sign,long S,long X,long Y) {
	BigRational c=c(X,Y);
	BigRational cx=cx(X,Y);
	BigRational cxx=cxx(X,Y);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational E2=E.subtract(new BigRational(2,1));
	BigRational R1=E.multiply(E1.multiply(pow(sign,c,E2)));
	BigRational R2=E.multiply(pow(sign,c,E1));
	R1=R1.multiply(cx.multiply(cx));
	R2=R2.multiply(cxx);
	return R1.add(R2);
    }

    public static  BigRational Cyy(int sign,long S,long X,long Y) {
	BigRational c=c(X,Y);
	BigRational cy=cy(X,Y);
	BigRational cyy=cyy(X,Y);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational E2=E.subtract(new BigRational(2,1));
	BigRational R1=E.multiply(E1.multiply(pow(sign,c,E2)));
	BigRational R2=E.multiply(pow(sign,c,E1));
	R1=R1.multiply(cy.multiply(cy));
	R2=R2.multiply(cyy);
	return R1.add(R2);
    }

    public static  BigRational Cxy(int sign,long S,long X,long Y) {
	BigRational c=c(X,Y);
	BigRational cx=cx(X,Y);
	BigRational cy=cy(X,Y);
	BigRational cxy=cxy(X,Y);
	BigRational E=new BigRational(S,131072);
	BigRational E1=E.subtract(new BigRational(1,1));
	BigRational E2=E.subtract(new BigRational(2,1));
	BigRational R1=E.multiply(E1.multiply(pow(sign,c,E2)));
	BigRational R2=E.multiply(pow(sign,c,E1));
	R1=R1.multiply(cx.multiply(cy));
	R2=R2.multiply(cxy);
	return R1.add(R2);
    }

    public static  BigRational Rxx(int sign,long S,long X,long Y) {
	BigRational t1=Axx(sign,S,X);
	BigRational t2=Bxx(sign,S,X);
	BigRational t3=Cxx(sign,S,X,Y);
	BigRational t=new BigRational(0,1);
	t=t.add(t1);
	t=t.add(t2);
	t=t.add(t2);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	return t;
    }

    public static  BigRational Ryy(int sign,long S,long X,long Y) {
	BigRational t1=Axx(sign,S,Y);
	BigRational t2=Bxx(sign,S,Y);
	BigRational t3=Cyy(sign,S,X,Y);
	BigRational t=new BigRational(0,1);
	t=t.add(t1);
	t=t.add(t2);
	t=t.add(t2);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	t=t.add(t3);
	return t;
    }

    public static  BigRational Rxy(int sign,long S,long X,long Y) {
	BigRational t=Cxy(sign,S,X,Y);
	t=t.multiply(new BigRational(4,1));
	return t;
    }

    /**This ends the list of partial derivatives.  Now we  
       give the functions for the main calculation in Chapter 18.
       Here is the main function*/

    public static  BigRational H(int sign,long S,long X,long Y) {
	BigRational BX=new BigRational(X,65536);
	BigRational BY=new BigRational(Y,65536);
	BigRational ONE=new BigRational(1,1);
	BX=BX.multiply(new BigRational(4,1));
	BY=BY.multiply(new BigRational(4,1));
	BigRational M1=ONE.add(BY.subtract(BX));
	BigRational M2=ONE.add(BX.subtract(BY));
	BigRational T1=M1.multiply(Rxx(sign,S,X,Y));
	BigRational T2=M2.multiply(Ryy(sign,S,X,Y));
	BigRational T3=Rxy(sign,S,X,Y);
	T3=T3.multiply(new BigRational(-2,1));
	BigRational T4=Rx(sign,S,X,Y);
	T4=T4.multiply(new BigRational(-4,1));
	BigRational T5=Ry(sign,S,X,Y);
	T5=T5.multiply(new BigRational(-4,1));
	BigRational T=T1.add(T2);
	T=T.add(T3);
	T=T.add(T4);
	T=T.add(T5);
	return T;
    }


    /**Here are the component functions*/

    public static  BigRational ax(long X) {
	BigRational BX=new BigRational(X,65536);
	BigRational ONE=new BigRational(1,1);
	BigRational C=BX.multiply(BX);
	C=C.multiply(C);
	BigRational A=C.subtract(ONE);
	A=A.divide(BX);
	A=A.divide(BX);
	A=A.divide(BX);
	A=A.multiply(new BigRational(1,8));
	return A;
    }

    public static  BigRational axx(long X) {
	BigRational BX=new BigRational(X,65536);
	BigRational B3=new BigRational(3,1);
	BigRational C=BX.multiply(BX);
	C=C.multiply(C);
	BigRational A=C.add(B3);
	A=A.divide(BX);
	A=A.divide(BX);
	A=A.divide(BX);
	A=A.divide(BX);
	A=A.multiply(new BigRational(1,8));
	return A;
    }

    public static  BigRational bx(long X) {
	BigRational BX=new BigRational(X,65536);
	BX=BX.multiply(new BigRational(1,2));
	return BX;
    }

    public static  BigRational bxx(long X) {
	return new BigRational(1,2);
    }


    public static  BigRational cx(long X,long Y) {
	BigRational BX=new BigRational(X,65536);
	BigRational BY=new BigRational(Y,65536);
	BigRational ONE=new BigRational(1,1);
	BigRational C=BY.multiply(BY);
	C=C.multiply(C);
	BigRational A=C.subtract(ONE);
	A=A.multiply(BX);
	BigRational B=BX.multiply(BX);
	B=B.add(BY.multiply(BY));
	B=B.multiply(B);
	B=B.add(B);
	A=A.divide(B);
	return A;
    }

    public static BigRational cy(long X,long Y) {
	return cx(Y,X);
    }

    public static  BigRational cxx(long X,long Y) {
	BigRational BX=new BigRational(X,65536);
	BigRational BY=new BigRational(Y,65536);
	BigRational B3=new BigRational(3,1);
	BigRational Y2=BY.multiply(BY);
	BigRational X2=BX.multiply(BX);
	BigRational D1=Y2.subtract(B3.multiply(X2));
	BigRational ONE=new BigRational(1,1);
	BigRational C=BY.multiply(BY);
	C=C.multiply(C);
	BigRational D2=C.subtract(ONE);
	BigRational NUM=D1.multiply(D2);
	BigRational B=BX.multiply(BX);
	B=B.add(BY.multiply(BY));
	B=B.multiply(B.multiply(B));
	BigRational DEN=B.add(B);
	return NUM.divide(DEN);
    }


    public static BigRational cyy(long X,long Y) {
	return cxx(Y,X);
    }


    public static  BigRational cxy(long X,long Y) {
	BigRational BX=new BigRational(X,65536);
	BigRational BY=new BigRational(Y,65536);
	BigRational B1=new BigRational(1,1);
	BigRational B2=new BigRational(2,1);
	BigRational XY=BX.multiply(BY);
	XY=XY.multiply(B2);
	BigRational XXYY=BX.multiply(BY);
	XXYY=XXYY.multiply(XXYY);
	XXYY=XXYY.add(B1);
	BigRational NUM=XXYY.multiply(XY);
	BigRational B=BX.multiply(BX);
	B=B.add(BY.multiply(BY));
	BigRational DEN=B.multiply(B.multiply(B));
	return NUM.divide(DEN);
    }


    public static double cxy(double x,double y) {
	double t=2*x*y*(1+x*x*y*y)/((x*x+y*y)*(x*x+y*y)*(x*x+y*y));
	return t;
    }


    /**Here is the controlled power function
       sign=-1 gives an under-approximation and
       sign=+1 gives an over-approximation.  The routine
       uses floating point arithmetic to make a guess. Then,
       after the guess is made, it is rigorously checked
       using exact arithmetic.  The checker is very slow.*/



    public static BigRational pow(int sign,BigRational A,BigRational E) {
	double a=A.toDouble();
	double e=E.toDouble();
	double x=Math.pow(a,e);
	double u=Math.pow(2,32)*x;
	long n=(long)(u);
	Long N=new Long(n+2*sign);
	BigRational X=new BigRational(N.toString(),"4294967296");// 2^32
	X.reduce();
	int test=BigRational.testPow(A,E,X);
	if(test!=sign) throw new ProofException("problem with power function");
	return X;
    }
}


    
