import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class EnergyFloat {

    /**This is the floating point version of the Energy class.
       The routines listed in the energy class are long and
       complicated and hard to read.  Here we have much simpler
       floating point routines. We can use the debugger to 
       check that the two things agree to high precision*/

    public static double R(long S,long X,long Y) {
	double big=65536.0;
	double e=S/big;
	double x=X/big;
	double y=Y/big;
	return A(e,x)+A(e,y)+2*B(e,x)+2*B(e,y)+4*C(e,x,y);
    }

    public static double A(double e,double x) {
	double t=a(x);
	double t1=Math.pow(t,e/2);
	return t1;
    }

    public static double B(double e,double x) {
	double t=b(x);
	double t1=Math.pow(t,e/2);
	return t1;
    }

    public static double C(double e,double x,double y) {
	double t=c(x,y);
	double t1=Math.pow(t,e/2);
	return t1;
    }

    public static double a(double x) {
	double t=(1+x*x)*(1+x*x)/(16*x*x);
	return t;
    }

    public static double b(double x) {
	double t=(1+x*x)/4;
	return t;
    }

    public static double c(double x,double y) {
	double t=(1+x*x)*(1+y*y)/(4*(x*x+y*y));
	return t;
    }


    /**Here is the long list of partial derivatives
       used for the second calculation in the Endgame section*/

    public static double Ax(double e,double x) {
	double u=e/2;
	return u*Math.pow(a(x),u-1)*ax(x);
    }


    public static double Bx(double e,double x) {
	double u=e/2;
	return u*Math.pow(b(x),u-1)*bx(x);
    }


    public static double Cx(double e,double x,double y) {
	double u=e/2;
	return u*Math.pow(c(x,y),u-1)*cx(x,y);
    }


    public static double Cy(double e,double x,double y) {
	double u=e/2;
	return u*Math.pow(c(x,y),u-1)*cy(x,y);
    }

    public static double Rx(long S,long X,long Y) {
	double big=65536.0;
	double e=S/big;
	double x=X/big;
	double y=Y/big;
	return Ax(e,x)+2*Bx(e,x)+4*Cx(e,x,y);
    }

    public static double Ry(long S,long X,long Y) {
	double big=65536.0;
	double e=S/big;
	double x=X/big;
	double y=Y/big;
	return Ax(e,y)+2*Bx(e,y)+4*Cy(e,x,y);
    }

    public static double Axx(double e,double x) {
	double u=e/2;
	double t1=u*(u-1)*Math.pow(a(x),u-2)*ax(x)*ax(x);
	double t2=u*Math.pow(a(x),u-1)*axx(x);
	return t1+t2;
    }

    public static double Bxx(double e,double x) {
	double u=e/2;
	double t1=u*(u-1)*Math.pow(b(x),u-2)*bx(x)*bx(x);
	double t2=u*Math.pow(b(x),u-1)*bxx(x);
	return t1+t2;
    }

    public static double Cxx(double e,double x,double y) {
	double u=e/2;
	double t1=u*(u-1)*Math.pow(c(x,y),u-2)*cx(x,y)*cx(x,y);
        double t2=u*Math.pow(c(x,y),u-1)*cxx(x,y);
	return t1+t2;
    }

    public static double Cyy(double e,double x,double y) {
	double u=e/2;
	double t1=u*(u-1)*Math.pow(c(x,y),u-2)*cy(x,y)*cy(x,y);
        double t2=u*Math.pow(c(x,y),u-1)*cyy(x,y);
	return t1+t2;
    }

    public static double Cxy(double e,double x,double y) {
	double u=e/2;
	double t1=u*(u-1)*Math.pow(c(x,y),u-2)*cx(x,y)*cy(x,y);
        double t2=u*Math.pow(c(x,y),u-1)*cxy(x,y);
	return t1+t2;
    }

    public static double Rxx(long S,long X,long Y) {
	double big=65536.0;
	double e=S/big;
	double x=X/big;
	double y=Y/big;
	return Axx(e,x)+2*Bxx(e,x)+4*Cxx(e,x,y);
    }

    public static double Ryy(long S,long X,long Y) {
	double big=65536.0;
	double e=S/big;
	double x=X/big;
	double y=Y/big;
	return Axx(e,y)+2*Bxx(e,y)+4*Cyy(e,x,y);
    }

    public static double Rxy(long S,long X,long Y) {
	double big=65536.0;
	double e=S/big;
	double x=X/big;
	double y=Y/big;
	return 4*Cxy(e,x,y);
    }

    /**The main function for the second test*/

    public static double H(long S,long X,long Y) {
	double big=65536.0;
	double x=X/big;
	double y=Y/big;
	double t1=(1-4*x+4*y)*Rxx(S,X,Y);
	double t2=(1+4*x-4*y)*Ryy(S,X,Y);
	double t3=-2*Rxy(S,X,Y);
	double t4=-4*Rx(S,X,Y);
	double t5=-4*Ry(S,X,Y);
	double t=t1+t2+t3+t4+t5;
	return t;
    }




    /**The basic derivatives*/



    public static double ax(double x) {
	double t=(-1+x*x*x*x)/(8*x*x*x);
	return t;
    }

    public static double axx(double x) {
	double t=(3+x*x*x*x)/(8*x*x*x*x);
	return t;
    }

    public static double bx(double x) {
	return x/2;
    }

    public static double bxx(double x) {
	return 1.0/2;
    }


    public static double cx(double x,double y) {
	double t=x*(-1+y*y*y*y)/(2*(x*x+y*y)*(x*x+y*y));
	return t;
    }

    public static double cy(double x,double y) {
	double t=y*(-1+x*x*x*x)/(2*(x*x+y*y)*(x*x+y*y));
	return t;
    }

    public static double cxx(double x,double y) {
	double t=(-3*x*x+y*y)*(y*y*y*y-1)/(2*(x*x+y*y)*(x*x+y*y)*(x*x+y*y));
	return t;
    }

    public static double cyy(double x,double y) {
	double t=(-3*y*y+x*x)*(x*x*x*x-1)/(2*(x*x+y*y)*(x*x+y*y)*(x*x+y*y));
	return t;
    }

    public static double cxy(double x,double y) {
	double t=2*x*y*(1+x*x*y*y)/((x*x+y*y)*(x*x+y*y)*(x*x+y*y));
	return t;
    }




}


    
