import java.awt.*;
import java.awt.geom.*;

/**THis does the main energy test*/

public class EnergyTest {

    public static boolean main(int mode,Box B) {
	if(mode==0) {return testFloat(B);}
	else {return testRat(B);}
    }

    public static boolean testFloat(Box B) {
	if(cutsAcrossWall(B)==true) return false;
	double t0=EnergyFloat.R(B.S0,65536,37837);
	double t1=EnergyFloat.R(B.S1,65536,37837);
	double[] t={t0,t1};

	long[] X={B.X0,B.X1};
	long[] Y={B.Y0,B.Y1};
	long[] S={B.S0,B.S1};

	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		for(int k=0;k<2;++k) {
		    double e1=EnergyFloat.R(S[i],X[j],Y[k]);
		    double e2=errorFloat(B);
 	            if(e1-e2<=t[i]) return false;
		}
	    }
	}
	return true;
    }


    public static double errorFloat(Box B) {
	double t=65536.0;
	double d1=(B.X1-B.X0)/t;
	d1=d1*d1;
	double d2=(B.S1-B.S0)/t;
	d2=d2*d2/512;
	return(d1+d2);
    }


    /**Here is the big rational test
       NOTE: We don't actually compare the given configuration to
       the TBP.  Rather we compare it to the nearby coords
       x=1
       y=37837/65536 (approx =) 1/Sqrt[3].  
       This has higher energy than that TBP because it
       does not lie in the region SMALL. Hence,
       this comparison suffices*/

    public static boolean testRat(Box B) {
	if(cutsAcrossWall(B)==true) return false;
	BigRational t0=Energy.R(1,B.S0,65536,37837);
	BigRational t1=Energy.R(1,B.S1,65536,37837);
	BigRational[] t={t0,t1};

	long[] X={B.X0,B.X1};
	long[] Y={B.Y0,B.Y1};
	long[] S={B.S0,B.S1};

	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		for(int k=0;k<2;++k) {
		    BigRational e1=Energy.R(-1,S[i],X[j],Y[k]);
		    BigRational e2=errorRat(B);
		    e1=e1.subtract(e2);
		    BigRational test=e1.subtract(t[i]);
		    if(test.isPositive()==false) return false;
		}
	    }
	}
	return true;
    }

    public static BigRational errorRat(Box B) {
	BigRational x0=new BigRational(B.X0,65536);
	BigRational x1=new BigRational(B.X1,65536);
	BigRational s0=new BigRational(B.S0,65536);
	BigRational s1=new BigRational(B.S1,65536);
	BigRational x=x0.subtract(x1);
	BigRational s=s0.subtract(s1);
	x=x.multiply(x);
	s=s.multiply(s);
	s=s.multiply(new BigRational(1,512));
	x=x.add(s);
	return x;
    }


    /**These configurations are automatically failed.
       Here 891968=(13)T 
            986240=(15+25/512)T
            44032=(43/64)T
            64512=(63/64)T
            with T=65536, our fundamental scale.
       What we are doing is failing a box if it
       cuts across any wall of our domain.  We
       do allow the box to cut across the upper
       parameter boundary. This doesn't matter 
       to us.*/

    public static boolean cutsAcrossWall(Box B) {
	if((B.S0<851968)&&(B.S1>851968)) return true;
	if((B.X0<44032)&&(B.X1>44032)) return true;
	if((B.Y0<44032)&&(B.Y1>44032)) return true;
	return false;
    }


}

