import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This is the window where things are drawn*/

public class PictureCanvas extends ScaleCanvas implements KeyListener,MouseListener,MouseMotionListener {
    Manager M;
    Box[] B=new Box[100000];
    int count=0;
    Point JX;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(20,530,510);
     }


    /**This is the main drawing routine.*/

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2; 
      drawWindow(g,false);
      drawBoxes(g);
      drawWindow(g,true);
      if(M.C.DISPLAY.L[0].on==1) drawFoliation(g); 
      if(M.C.DISPLAY.L[1].on==1) exportBoxes(); 
   }

    public void drawWindow(Graphics2D g,boolean edge) {
	g.setColor(new Color(50,60,70));
	if(edge==false) g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(0,0);
	gp.lineTo(0,1);
	gp.lineTo(1,1);
	gp.lineTo(1,0);
	gp.closePath();
 	gp=transform(gp);
	g.setColor(Color.black);
	if(edge==false) g.fill(gp);
	g.setColor(Color.white);
	if(edge==true) g.draw(gp);

	gp.reset();
	double a=43.0/64;
	gp.moveTo(a,a);
	gp.lineTo(1,a);
	gp.lineTo(1,1);
	gp.lineTo(a,1);
	gp.closePath();
	gp=transform(gp);
	g.setStroke(new BasicStroke(2));
	g.setColor(Color.white);
	if(edge==true) g.draw(gp);
	g.setStroke(new BasicStroke(1));
    }

    public void drawBoxes(Graphics2D g) {
	for(int i=0;i<count;++i) {
	    double s=M.C.getParameter();
	    double big=65536.0;
	    if((B[i].S0/big<=s)&&(B[i].S1/big>=s)) {
	       Path2D.Double gp=B[i].toPath();
	       gp=transform(gp);
	       g.setColor(Color.red);
	       if(B[i].type==2) g.setColor(new Color(0,0,200));
	       if(B[i].type==3) g.setColor(new Color(200,0,200));
	       g.fill(gp);
	       g.setColor(Color.white);
	       g.draw(gp);
	    }
	}
    }
    public void exportBoxes() {
	FileWriter OUT=new FileWriter("Output/graph");
	for(int i=0;i<count;++i) {
	    double s=M.C.getParameter();
	    double big=65536.0;
	    Color C;
	    if((B[i].S0/big<=s)&&(B[i].S1/big>=s)) {
	       Path2D.Double gp=B[i].toPath();
	       C=new Color(150,150,150);
	       if(B[i].type==2) C=Color.white;
	       if(B[i].type==3) C=new Color(50,50,50);
	       OUT.polyWrite(gp,C,Color.black);
	    }
	}
    }

    public void drawFoliation(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	for(int j=0;j<=32;++j) {
	    double u=1.0*j/32;
	    double t0=(1-u)*(55.0/64)+u*56/64;
	   for(int i=0;i<=100;++i) {
	      u=1.0*i/100;
	      double t=u*1.0/128;
	      if(i==0) gp.moveTo(t0+t-t*t,t0-t-t*t);
	      if(i!=0) gp.lineTo(t0+t-t*t,t0-t-t*t);
	   }
	}
	gp=transform(gp);
	g.setColor(Color.yellow);
	g.draw(gp);
    }



    /**Mouse events*/
    public void mousePressed(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {
       MouseData J=MouseData.process(e);
       JX=J.X;
    }
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {
 	 requestFocus();
    }
    public void mouseExited(MouseEvent e) {}  

    /**accepts mouse clicks and rescales*/
 
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	  if(J.mode==1) scaleUp(J.X,-1);
	  if(J.mode==3) scaleUp(J.X,1);
     }

    public void doMouseClick(int mode, Point X) {
	  if(mode==1) scaleUp(X,-1);
	  if(mode==3) scaleUp(X,1);
     }

    public void mouseDragged(MouseEvent e) {

    }


    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	int mode=0;
	if(ch=='z') mode=1;
	if(ch=='x') mode=2;
	if(ch=='c') mode=3;
	if(ch=='b') mode=1;
	if(ch=='n') mode=2;
	if(ch=='m') mode=3;
	if(mode>0) doMouseClick(mode,JX);
	M.repaint();
    }

 
    public void keyPressed(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {}

}



