import java.awt.*;
import java.awt.geom.*;

/**This is the basic object for the subdivision alg.
The corners of the square are (x0,y0) and (x1,y1).
The two parameters (exponents) are s1 and s2*/

public class Proof1 implements Runnable {
    public boolean HALT;
    Manager M;
    Box[] LIST=new Box[1000];
    int count=0;
    int total=0;
    long TIME;

    public Proof1 () {
	HALT=true;
    }

    public Proof1 (Manager m) {
	this.M=m;
	HALT=true;
    }

    public void run() {
	TIME=Time.time();
	HALT=false;
	LIST[0]=Box.initial();
	count=1;
	long steps=0;
        long a=56320;
	long b=57344;
	Box CAGE=new Box(a,a,b,b,986112,16*65536);

	while(HALT==false) {
	    Box B=LIST[count-1];

	    boolean irr=isIrrelevant(B);
	    boolean eng=false;
	    boolean cage=false;
	    if(irr==false) {
      	       if(B.inside(CAGE)==true) cage=true;
	       if(cage==false) eng=EnergyTest.main(M.C.TEST.mode,B);
	    }

	    if(irr==true) eliminate(1);
	    if(eng==true) eliminate(2);
	    if(cage==true) eliminate(3);
	    if((cage==false)&&(irr==false)&&(eng==false)) subdivide();
	    ++steps;
            printStatus(steps);
	    if(count==0) HALT=true;
	}  
        System.out.println("done");
    }

    public void printStatus(long s) {
	Long S=new Long(s);
	Long T=new Long(total);
	M.C.MESSAGE[0]="Chapter 17 test";
	M.C.MESSAGE[1]="steps: "+S.toString();
	M.C.MESSAGE[2]="passed: "+T.toString();
        M.C.MESSAGE[3]="time: "+Time.convert(Time.time()-TIME);
	M.C.MESSAGE[4]="";
	M.C.repaint();
    }

    public void eliminate(int k) {
	Box B=LIST[count-1];
	M.P.B[M.P.count]=LIST[count-1];
	M.P.B[M.P.count].type=k;
	++M.P.count;
	double s=.5*(B.S0+B.S1)/65536;
	if(M.C.SLICE.mode==1) M.C.setParameter(s);
	M.repaint();
	--count; 
	++total;
    }

    public void subdivide() {
	Box B=LIST[count-1];
	long X=B.X1-B.X0;
	long S=B.S1-B.S0;
	if(16*X>S) subdivide1();
	else subdivide2();
    }

    public void subdivide1() {
	Box B=LIST[count-1];
	LIST[count-1]=B.sub1(0,0);
	LIST[count-0]=B.sub1(1,0);
	LIST[count+1]=B.sub1(0,1);
	LIST[count+2]=B.sub1(1,1);
	count=count+3;
    }

    public void subdivide2() {
	Box B=LIST[count-1];
	LIST[count-1]=B.sub2(1);
	LIST[count-0]=B.sub2(0);
	count=count+1;
    }
    public static boolean isIrrelevant(Box B) {
	if(B.S1<=851968) return true;
	if(B.S0>=986240) return true;
	if(B.X1<=44032) return true;
	if(B.Y1<=44032) return true;
	return false;
    }

}

