import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This is my own extension of java's Canvas class.  If you
make classes which extend the ScaleCanvas rather than the
Canvas, you have automatic scaling capabilities.*/



public class ScaleCanvas extends Canvas implements MouseListener, MouseMotionListener {
    Complex SOURCE=new Complex(0,0);
    AffineTransform[] A=new AffineTransform[2];
    double SCALE;

    /**This creates a new ScaleCanvas, moves the origin to the point
       (100,100), and scales up by a factor of 200.*/

     public ScaleCanvas() {
	 setScales(100,100,200);  
         SCALE=Math.pow(2,.5);
     }

    /**This sets the initial scaling for the window.*/

    public void setScales(int m1,int m2,int n) {
	A[0]=AffineTransform.getTranslateInstance(m1,m2);
	A[1]=AffineTransform.getScaleInstance(n,-n);
    }


    /**double buffering - run automatically without 
       explicitly being invoked in the paint routine.
       This routine is a programming trick to avoid 
       a flickering effect on some computers. */

    public void update(Graphics g) {
        Graphics g2;
        Image offscreen = null;
        offscreen = createImage(this.getWidth(),this.getHeight());
        g2 = offscreen.getGraphics();
        paint(g2);
        g.drawImage(offscreen, 0, 0, this);
	g2.dispose();
	offscreen.flush();
    }
    /**end double buffering*/


    /**This doesn't do anything, because when you make an
       extension of the ScaleCanvas, you define your own 
       paint routine.  In general, the paint routine is
       what draws stuff in the Canvas.*/

    public void paint(Graphics g2) {}


    /**This routine converts a graphics object from the
       mathematical coordinates you compute in, and the
       rendering coordinates.*/

    public Path2D.Double transform(Path2D.Double H) {
	Path2D.Double HH=new Path2D.Double(H);
	HH.transform(A[1]);   //scale
	HH.transform(A[0]);   //translate
	return(HH);
    }


    /**ZOOM: This routine is the companion to the scaling routine.  
       After I have zoomed into the picture in some way, my further
       mouse clicks have different meanings than they did before the
       zoom.  In other words, suppose that I dilate the picture by
       100000.  When I click on the point with pixel value (50,50)
       I really mean to select the number (.00005,.00005). This routine
       changes the pixel value of the point to the intended value.*/

    public Complex unTransform(Point X) {
       double tx=X.x;
       double ty=X.y;
       return(unTransform(tx,ty));
    }


    /**This is a real valued version of the same thing**/
    public Complex unTransform(double tx,double ty) {
       double ux=A[0].getTranslateX();
       double uy=A[0].getTranslateY();
       double sx=A[1].getScaleX();
       double sy=A[1].getScaleY();
       ux=(ux-tx)+tx;
       uy=(uy-ty)+ty;
       tx=tx-ux;
       ty=ty-uy;
       tx=tx/sx;
       ty=ty/sy;
       Complex z=new Complex(tx,ty);
       return(z);
    }



    /**ZOOM: this routine scales up or down with the mouse click.
       The first argument is the point about which you scale, and
       the second argument just tells you whether to go up or down.
       The basic idea is that I have globally defined some
       AffineTransform objects.  These will rescale a Path2D.Double
       whenever I draw it.  So, I just modify the components of
       these AffineTransforms whenever I do this routine.*/

    public void scaleUp(Point X,int k) {

	double scale=SCALE;
	double ss=scale;
	if(k==1) ss=1/scale;

	double sx=A[1].getScaleX();
	double sy=A[1].getScaleY();
	double tx=X.x;
	double ty=X.y;
	double ux0=A[0].getTranslateX();
	double uy=A[0].getTranslateY();

	double ux1=ss*(ux0-tx)+tx;
	uy=ss*(uy-ty)+ty;
	sx=sx*ss;
        sy=sy*ss;
	A[1]=AffineTransform.getScaleInstance(sx,sy);
	A[0]=AffineTransform.getTranslateInstance(ux1,uy);
	repaint();
    }

    /**These routines don't do anyhing, because you create
       your own versions in the class which extends the
       ScaleCanvas.*/

    public void mousePressed(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseMoved(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {}
    public void mouseDragged(MouseEvent e) {}

}
