import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This is the main class for the graphical user interface*/


public class ControlCanvas extends ScaleCanvas implements MouseListener  {
    Manager M;
    ListenSquare GO,STOP;
    ControlPanel SYMM,POLY,DOMAIN,MAIN,PRINT;
    SelectInteger BCOEFF,DCOEFF,CHOICE,DEGREE;
    ListenSquare[][][] TEST=new ListenSquare[2][2][4];
    int[][][] PASS=new int[2][2][4];
    CubeDisplay CD;
    double VOLUME;
    int STEPS;
    boolean SINGLE;
    int[] AGE=new int[4];
    String[] MESSAGE=new String[16];
    PolyTester PT;


     public ControlCanvas() {
	 addMouseListener(this);
	 GO=new ListenSquare(5,375,40,20);
	 STOP=new ListenSquare(5,400,50,20);
	 setControlPanels();
	 BCOEFF=new SelectInteger(255,55,40,20,94,0,100,1);
	 DCOEFF=new SelectInteger(255,80,40,20,13,0,200,1);
	 CHOICE=new SelectInteger(115,10,60,30,0,0,16,1);
	 DEGREE=new SelectInteger(5,325,40,20,0,0,5,1);
	 VOLUME=0;
	 for(int i=0;i<16;++i) MESSAGE[i]=new String();
	 PT=new PolyTester();
	 setTestRecord();
     }


    public void setControlPanels() {

      Color[] C0={new Color(80,160,255),Color.white,Color.white,Color.black,Color.red};

      String[] SymmString={"symm lemma 1","symm lemma 2","lemma choice"};
      int[] SymmState={1,1};
      SYMM=new ControlPanel(C0,SymmString,SymmState,2);

      String[] PolyString={"hessian trace","hessian det","function choice"};
      int[] PolyState={1,1};
      POLY=new ControlPanel(C0,PolyString,PolyState,2);

      String[] DomainString={"11  00","12  01","31  10","32  11","affine cube"};
      int[] DomainState={1,1,1,1};
      DOMAIN=new ControlPanel(C0,DomainString,DomainState,4);


      String[] MainString={"posdom tests","print poly","custom","action"};
      int[] MainState={1,0,0};
      MAIN=new ControlPanel(C0,MainString,MainState,3);

      String[] PrintString={"entire poly","up to degree:","poly printout"};
      int[] PrintState={1,0};
      PRINT=new ControlPanel(C0,PrintString,PrintState,2);

    }


    public void setTestRecord() {
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		for(int k=0;k<4;++k) {
		    TEST[i][j][k]=new ListenSquare(180+120*i+40*j,410+20*k,15,15);
		    PASS[i][j][k]=-1;
		}
	    }
	}
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
      RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawCubeDisplay(g);
      drawTestStatus(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(100,0,100));
	g.fillRect(0,0,getWidth(),getHeight());
    }

    public void drawControls(Graphics2D g) {
	if(PT.HALT==true) {
            GO.render(g,new Color(0,180,0));
            g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
	}
	if(PT.HALT==false) {
           STOP.render(g,Color.red); 
           g.drawString("stop",(int)(STOP.x+5),(int)(STOP.y+15));
	}
         g.setFont(new Font("Helvetica",Font.PLAIN,12));
         g.setColor(Color.white);

      MAIN.render(g,5,5,100);
      if(MAIN.mode==1) {
         PRINT.render(g,5,270,100); 
         if(PRINT.mode==1) DEGREE.render(g,Color.red,Color.white,Color.white);
      }
      SYMM.render2(g,5,75,100);
      POLY.render2(g,5,130,100);
      DOMAIN.render2(g,5,185,100);
      CHOICE.render(g,Color.red,Color.white,Color.white);
      g.drawString("select single",115,54);
      g.drawString("polys using",115,69);
      g.drawString("the red arrows",115,84);
      g.setFont(new Font("Helvetica",Font.PLAIN,16));
      g.drawString("record of the tests:",5,445);
      g.drawString("bow energy term:",230,15);
      g.drawString("(b^2)/B + (d^2)/D",230,40);
      g.drawString("B=",230,69);
      g.drawString("D=",230,93);
      BCOEFF.render(g,Color.red,Color.white,Color.white);
      DCOEFF.render(g,Color.red,Color.white,Color.white);
      g.setColor(Color.black);
    }

    public void drawCubeDisplay(Graphics2D g) {
	int[] A=detectSingle();
	if(A==null) return;
	try{CD.render(g,MAIN.mode);}
	catch(Exception e) {}
    }

    public void drawTestStatus(Graphics2D g) {
	g.setColor(new Color(160,0,230));
	g.fillRect(160,360,235,135);
	g.setColor(Color.white);
	g.drawRect(160,360,235,135);
        g.setFont(new Font("Helvetica",Font.PLAIN,20));
	g.setColor(Color.white);
	g.drawString("Lemma 1",170,380);
	g.drawString("Lemma 2",290,380);
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString("trace",170,400);
	g.drawString("det",217,400);
	g.drawString("trace",290,400);
	g.drawString("det",337,400);
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		for(int k=0;k<4;++k) {
		    Color C=Color.black;
		    if(PASS[i][j][k]==0) C=Color.red;
		    if(PASS[i][j][k]==1) C=Color.green;
		    if(PASS[i][j][k]==2) C=new Color(0,50,255);
                    int a=M.C.SYMM.L[i].on; 
                    int b=M.C.POLY.L[j].on;
	            int c=M.C.DOMAIN.L[k].on;
		    if(a*b*c==0) C=new Color(0,0,0,0);
                    TEST[i][j][k].render(g,C);
		}
	    }
	}
    }

    public void setCubeDisplay() {
	int[] A=detectSingle();
	if(A==null) return;
	int count=0;
	if(A[0]==0) count=5;
	if(A[0]==1) count=4;
	int[][] X=AffineCubeData.X(A[0],A[2]);
	CD=new CubeDisplay(120,120,count,X);
    }

    public void doGo() {
	if(MAIN.mode!=1) {
	  if(PT.HALT==false) return;
	  PT=new PolyTester(this.M);
	  new Thread(PT).start();
	}
	if(MAIN.mode==1) doPrint();
    }







    public void doPrint() {
	FileWriter OUT=new FileWriter("saved_polys");
	int B=BCOEFF.val;
	int D=DCOEFF.val;
	for(int i=0;i<2;++i) {
	   for(int j=0;j<2;++j) {
	       for(int k=0;k<4;++k) {
		   int a=SYMM.L[i].on; 
                   int b=POLY.L[j].on;
		   int c=DOMAIN.L[k].on;
		   if(a*b*c==1) {
                       Poly5 P=new Poly5();
	               if((i==0)&&(j==0)) P=PolyLemma1.hessianTrace(k);
	               if((i==0)&&(j==1)) P=PolyLemma1.hessianDet(k);
	               if((i==1)&&(j==0)) P=PolyLemma2.hessianTrace(k,B,D);
	               if((i==1)&&(j==1)) P=PolyLemma2.hessianDet(k,B,D);
		       if(PRINT.mode==0) P.print(OUT,"test");
		       if(PRINT.mode==1) P.print(OUT,"test",DEGREE.val);
		   }
	       }
	   }
	}
    }



    public void selectSingle(Point X) {
	CHOICE.modifyCyclic(X);
	if(CHOICE.isModified(X)==1) {
            selectSingle(CHOICE.val);
	    setCubeDisplay();
	}
    }


    public void selectPolyPrint(Point X) {
	PRINT.switchMode(X);
	DEGREE.modify(X);
    }


    public void selectSingle(int t) {
        int t0=t%2;
	t=(t-t0)/2;
	int t1=t%4;
	t=(t-t1)/4;
	int t2=t%2;
	for(int i=0;i<2;++i) SYMM.L[i].on=0;
	for(int j=0;j<2;++j) POLY.L[j].on=0;
	for(int k=0;k<4;++k) DOMAIN.L[k].on=0;
	SYMM.L[t2].on=1;
	POLY.L[t0].on=1;
	DOMAIN.L[t1].on=1;
    }

    public int[] detectSingle() {
	int a=0;
	int b=0;
	int c=0;
	for(int i=0;i<2;++i) a=a+SYMM.L[i].on;
	for(int i=0;i<2;++i) b=b+POLY.L[i].on;
	for(int i=0;i<4;++i) c=c+DOMAIN.L[i].on;
	if(a*b*c !=1) return null;
	for(int i=0;i<2;++i) {if(SYMM.L[i].on==1) a=i;}
	for(int i=0;i<2;++i) {if(POLY.L[i].on==1) b=i;}
	for(int i=0;i<4;++i) {if(DOMAIN.L[i].on==1) c=i;}
	int[] A={a,b,c};
	return A;
    }

    public void mouseClicked(MouseEvent e) {
       MouseData J=MouseData.process(e);
       if(GO.inside(J.X)==1) doGo();
       if(STOP.inside(J.X)==1) PT.HALT=true;
       int test=MAIN.switchMode(J.X);
       if(test==20) DocumentControl.action(M.D);
       if(MAIN.mode==1) selectSingle(CHOICE.val);
       test=SYMM.toggle(J.X);
       if(test==20) DocumentControl.lemma(M.D);
       test=POLY.toggle(J.X);
       if(test==20) DocumentControl.function(M.D);
       test=DOMAIN.toggle(J.X);
       if(test==20) DocumentControl.cube(M.D);
       BCOEFF.modify(J.X);
       DCOEFF.modify(J.X);
       try{CD.process(J.X);}
       catch(Exception ee) {}
       selectSingle(J.X);
       selectPolyPrint(J.X);
       repaint();
    }


    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
}

