import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This class displays the coordinates for our
   affine cube parametrizations.  It is part of the
   graphical user interface.*/

public class CubeDisplay {
    int X,Y;
    SelectInteger[][] CUBE =new SelectInteger[5][2];
    SelectInteger STEP;
    int COUNT;


    public CubeDisplay() {}

    public CubeDisplay(int x,int y,int count,int[][] c) {
	X=x;
	Y=y;
	COUNT=count;
	for(int i=0;i<count;++i) {
	    for(int j=0;j<2;++j) {
		CUBE[i][j]=new SelectInteger(x+30+j*130,y+i*30,40,20,c[i][j],-1024,1024,1);
	    }
	}
	STEP=new SelectInteger(x+210,y+206,40,20,0,0,5,1);
    }

    public void render(Graphics2D g,int k) {
	String[] S0={"a=","b=","c=","d=","e="};
	String[] S1={"(1-t1) +","(1-t2) +","(1-t3) +","(1-t4) +","{1-t5) +"};
	String[] S2={"(t1)","(t2)","(t3)","(t4)","(t5)"};

	g.setColor(new Color(30,0,60));
	g.fillRect(X-5,Y-5,280,240);
	g.setColor(Color.white);
	g.drawRect(X-5,Y-5,280,240);
	for(int i=0;i<COUNT;++i) {
            g.setFont(new Font("Helvetica",Font.PLAIN,14));
	    g.drawString(S0[i],X+5,Y+15+30*i);
	    g.drawString(S1[i],X+108,Y+15+30*i);
	    g.drawString(S2[i],X+240,Y+15+30*i);
	    for(int j=0;j<2;++j) {
		Color C=new Color(0,0,100);
		if(k==2) C=new Color(50,100,255);
		CUBE[i][j].render(g,C,Color.white,Color.white);
	    }
	} 
	Color C=new Color(0,0,100);
	if(k==2) C=new Color(50,100,255);
	STEP.render2(g,C,Color.white,Color.white);
	if(COUNT==5) drawFormula0(g);
	if(COUNT==4) drawFormula1(g);

    }


    public void drawFormula0(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString("512 p0=(+a+e,b)",X+10,Y+175);
	g.drawString("512 p2=(-a+e,b)",X+10,Y+200);
	if(CUBE[3][0].val>0) g.drawString("512 p3=(c,d)",X+10,Y+225);
	if(CUBE[3][0].val<0) g.drawString("512 p1=(c,d)",X+10,Y+225);
	g.setColor(Color.yellow);
	g.drawString("symmetrization",X+140,Y+175);
	g.drawString("sets c=0 and e=0",X+140,Y+195);
	g.setColor(new Color(70,120,255));
	g.drawString("arrow ",X+140,Y+212);
	g.drawString("strength ",X+140,Y+227);
    }


    public void drawFormula1(Graphics2D g) {
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString("512 p0=(a,b)",X+10,Y+175);
	g.drawString("512 p1=(0,-c+d)",X+10,Y+200);
	g.drawString("512 p3=(0,+c+d)",X+10,Y+225);
	g.setColor(Color.yellow);
	g.drawString("symmetrization",X+140,Y+175);
	g.drawString("sets b=0 and d=0",X+140,Y+195);
	g.setColor(new Color(70,120,255));
	g.drawString("arrow ",X+140,Y+212);
	g.drawString("strength ",X+140,Y+227);
    }

    public int[][] getCoords() {
	int[][] C=new int[COUNT][2];
	for(int i=0;i<COUNT;++i) {
	    for(int j=0;j<2;++j) {
		C[i][j]=CUBE[i][j].val;
	    }
	}
	return C;
    }

    public void process(Point xx) {
	try {
            STEP.modify(xx);
	    for(int i=0;i<COUNT;++i) {
		for(int j=0;j<2;++j) {
		    CUBE[i][j].step=(int)(Math.pow(2,STEP.val));
		    CUBE[i][j].modify(xx);
		}
	    }
	}
	catch(Exception e) {}
    }


}


