import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void action(DocumentCanvas D) {
	String S="action mode";
	S=S+"\n\nThere are thre main modes for this program.";
	S=S+"\n\n1. posdom tests:  In this mode you run the tests for the polynomials.  Once you have selected which polynomials you want to test, you press the green go button.  You can halt the tests any time using the red stop button.";
	S=S+"\n\n2.  In this mode you can print the polynomials to a file. The file is called saved_polys, and it appears in the same directory as the rest of the code. You can use this as a debugging tool.  You can enter the mathematica files debug_symmpoly1_trace, debug_symmpoly1_det, debug_symmpoly2 into Mathematica and see that the polynomials produced here match the ones produced in Mathematica.  The Mathematica code is more transparent, so you can see what is going on more easily.";

	S=S+"\n\n3. Custom:  When you are in this mode you should test polynomials one at a time. You make the change to one-at-a-time by clicking on the big red arrow keys at the bottom left.  These arrow keys cycle through the 16 polynomials in some order.  Once you have selected a single polynomial you want to test, you can modify the bounds of the affine cube parametrization and then run the test.\n\nThere is one subtle point about the custom feature.  You have to select the poly-to-be-tested using the red arrows. If you try to make adjustments (on the control panels) after you have used the red arrows, the test can get messed up.  I hope to make this more robust at some point.";

	sendTo(D,S);
    }



    public static void lemma(DocumentCanvas D) {
	String S="lemma choice";
	S=S+"\n\nBy clicking the buttons on this control panel, you decide whether you test the polys for the Symmetrization Lemma 1 and the Symmetrization Lemma 2 separately or together.";	
        sendTo(D,S);
    }


    public static void function(DocumentCanvas D) {
	String S="function choice";
	S=S+"\n\nBy clicking the buttons on this control panel, you decide whether you test the Hessian traces and the Hessian determinants together or separately.  The dets. take considerably longer to run. They are much larger polynomials.";
        sendTo(D,S);
    }


    public static void cube(DocumentCanvas D) {
	String S="affine cube choice";
	S=S+"\n\nIn the monograph we described affine cubical coverings for our domains.  Each lemma involves 4 affine cubes. For Lemma 1 there are 2 domains, each covered by 2 affine cubes.  For Lemma 2 there is one domain covered by 4 affine cubes. This window lets you test the functions relative to each of the affine cubes, either separately or together.";

S=S+"\n\nThe writing on this control panel is supposed to serve as a mnemonic for which button controls which affine cube.  For instance, the first line reads 11 00.  The 11 indicates that we are testing relative to affine cube 1 in the covering of the domain \u03A9'_1 in Lemma 1 and that we are testing the affine cube corresponding to the indices 00 for the covering of  \u03A9''_2 in Lemma 2.  These numbers also match the notation in the Mathematica files and make it easier to match up the functions produced by the java program and the functions produced by the Mathematica programs.";
        sendTo(D,S);
    }



}


