import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This is our class for a rational monomial.  The coefficient
c is a big rational and then the list e is the exponent list.
For instance c=7 and e={3,2,1,0,1} would be the monomial

      7 x0^3 x1^2 x2 x4

*/



public class Mono5 {
    BigRational c;
    int[] e=new int[5];


    /**These are the constructors*/

    public Mono5() {}

    public Mono5(Mono5 a) {
	this.c=new BigRational(a.c);
	for(int i=0;i<5;++i) this.e[i]=a.e[i];
    }

    public Mono5(long c0,long[] ee) {
	c=new BigRational(c0);
	for(int i=0;i<5;++i) e[i]=(int)(ee[i]);
    }

    public Mono5(BigRational c0,int[] ee) {
	c=new BigRational(c0);
	for(int i=0;i<5;++i) e[i]=ee[i];
    }


    /**negates the monomial*/

    public Mono5 negate() {
	Mono5 x=new Mono5(this);
	x.c=x.c.negate();
	return x;
    }

    /**Evaluates a monomial on a rational*/

    public BigRational evaluate(BigRational[] x) {
	BigRational a=new BigRational(c);
	for(int i=0;i<5;++i) {
	    for(int j=0;j<e[i];++j) {
		a=a.multiply(x[i]);
	    }
	}
	return(a);
    }

    /**Multiplies two monomials together*/

    public static Mono5 times(Mono5 A,Mono5 B) {
	Mono5 C=new Mono5();
	C.c=A.c.multiply(B.c);
	for(int i=0;i<5;++i) C.e[i]=A.e[i]+B.e[i];
	return(C);
    }

    /**ith partial derivative*/
    public Mono5 diff(int i) {
	Mono5 m=new Mono5(this);
	if(m.e[i]==0) {
	    int[] e={0,0,0,0,0};
	    return new Mono5(new BigRational("0","1"),e);
	}
	m.c=m.c.multiply(new BigRational(m.e[i]));
	--m.e[i];
	return m;
    }


    /**Computes the degree of the monomial*/
    public int degree() {
	int tot=0;
	for(int i=0;i<5;++i) tot=tot+e[i];
	return tot;
    }


    /**printouts*/


    /**prints the monomial to the command line*/

    public void print() {
	System.out.print("{{");
	for(int i=0;i<5;++i) {
	    System.out.print(e[i]);
	    if(i<4) System.out.print(",");
	    if(i==5) System.out.print("}");
	}
	System.out.print("},");
	c.print();
	System.out.print("}");
    }

    /**Prints numerical approximations to the monomial.
       This is useful if the coefficient of the monomial
       has enormous complexity, e.g. 
       234324543435436545437121264236788/124789799896781218564678508234713*/

    public void printN() {
	System.out.print("{{");
	for(int i=0;i<5;++i) {
	    System.out.print(e[i]);
	    if(i<4) System.out.print(",");
	    if(i==5) System.out.print("}");
	}
	System.out.print("},");
	c.printN();
	System.out.print("}");
    }

    public void println() {
	this.print();
	System.out.println("");
    }

    /**prints the monomial to a file*/

    public void print(FileWriter OUT) {
	OUT.print("{"+c.string()+",{");
	for(int i=0;i<5;++i) {
	    OUT.print(e[i]);
	    if(i<4) OUT.print(",");
	    if(i==4) OUT.print("}");
	}
	OUT.print("}");
    }

}




