import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This produces the polynomials for the first
   symmetrization test*/

public class PolyLemma1 {

    /**These routines are the main ones used for the
       tests of Symm Lemma 1.*/

    public static Poly5 hessianDet(int k) {
	Poly5 P=basic(k);
	return PolySupport.hessianDet(P,2,4);
    }

    public static Poly5 hessianTrace(int k) {
	Poly5 P=basic(k);
	return PolySupport.hessianTrace(P,2,4);
    }


    /**These routines are used for the custom test,
       when the affine cube is specified by C.
       They are not part of the formal proof.*/

    public static Poly5 hessianDet(int[][] C) {
	Poly5 P=basic(C);
	return PolySupport.hessianDet(P,2,4);
    }

    public static Poly5 hessianTrace(int[][] C) {
	Poly5 P=basic(C);
	return PolySupport.hessianTrace(P,2,4);
    }

    /**For each choice of k we use a different affine cube*/


    public static Poly5 basic(int k) {
	if(k==0) return basic(AffineCubeData.A11());
	if(k==1) return basic(AffineCubeData.A12());
	if(k==2) return basic(AffineCubeData.A31());
	if(k==3) return basic(AffineCubeData.A32());
	return null;
    }

    /**This is the basic polynomial.  The input is an
       affine cube and the output is a polynomial.
       After we compute thw polynomial, we 
       test the determinant and trace of its
       hessian with respect to the variables "x2" and "x4".*/

    public static Poly5 basic(int[][] d) {
	Poly5 x0=PolySupport.makeLinear(d[0][0],d[0][1],0);
	Poly5 y0=PolySupport.makeLinear(d[1][0],d[1][1],1);
	Poly5 x3=PolySupport.makeLinear(d[2][0],d[2][1],2);
	Poly5 y3=PolySupport.makeLinear(d[3][0],d[3][1],3);
	Poly5 e= PolySupport.makeLinear(d[4][0],d[4][1],4);
	PolyRat S=PolySupport.stereoFunction();
	Poly5 Z=new Poly5();
	Poly5[] P1={Poly5.plus(e,x0),y0,x3,y3,Z};
	Poly5[] P2={Poly5.minus(e,x0),y0,x3,y3,Z};
	Poly5[] P3={x0,y0,Z,y3,Z};
	PolyRat R1=S.compose(P1);
	PolyRat R2=S.compose(P2);
	PolyRat R3=S.compose(P3);
	R3.P=R3.P.scale(new BigRational("2","1"));
	PolyRat R4=PolyRat.minus(PolyRat.plus(R1,R2),R3);
	R4.P=PolyCompress.main(R4.P);
	R4.P.clearDenominator();
	return R4.P;
    }

}

