import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;

/**This produces the polynomials for the second symmetrization
   lemma test.  Note that these are polynomials in 4 variables,
   but we use our 5-variable class to handle them.  We simply
   set the last variable exponent to 0 in all cases*/


public class PolyLemma2 {

    /**These two routines match the corresponding routines
       in mathematica*/

    public static Poly5 hessianDet(int k,int B,int D) {
	if(k==0) return hessianDet(0,0,B,D);
	if(k==1) return hessianDet(0,1,B,D);
	if(k==2) return hessianDet(1,0,B,D);
	if(k==3) return hessianDet(1,1,B,D);
	return null;
    }

    public static Poly5 hessianTrace(int k,int B,int D) {
	if(k==0) return hessianTrace(0,0,B,D);
	if(k==1) return hessianTrace(0,1,B,D);
	if(k==2) return hessianTrace(1,0,B,D);
	if(k==3) return hessianTrace(1,1,B,D);
	return null;
    }


    public static Poly5 hessianDet(int choice,int sign,int B,int D) {
	int[][] C=getCoords(choice,sign);
	return hessianDet(C,B,D);
    }

    public static Poly5 hessianTrace(int choice,int sign,int B,int D) {
	int[][] C=getCoords(choice,sign);
	return hessianTrace(C,B,D);
    }

    public static Poly5 hessianDet(int[][] C,int B,int D) {
	PolyRat R=basic(C);
	R=PolyRat.plus(R,positiveKick(C,B,D));
	R.P=PolyCompress.main(R.P);
	R.P.clearDenominator();
	return PolySupport.hessianDet(R.P,1,3);
    }

    public static Poly5 hessianTrace(int[][] C,int B,int D) {
	PolyRat R=basic(C);
	R=PolyRat.plus(R,positiveKick(C,B,D));
	R.P=PolyCompress.main(R.P);
	R.P.clearDenominator();
	return PolySupport.hessianTrace(R.P,1,3);
    }



    /**There are 4 cubes, given by 
       choice=0,1 and sign=0,1*/

    public static Poly5[] getCube(int choice,int sign) { 
	int[][] D=getCoords(choice,sign);
	return getCube(D);
    }

    public static Poly5[] getCube(int[][] D) { 
	Poly5 a=PolySupport.makeLinear(D[0][0],D[0][1],0);
	Poly5 b=PolySupport.makeLinear(D[1][0],D[1][1],1);
	Poly5 c=PolySupport.makeLinear(D[2][0],D[2][1],2);
	Poly5 d=PolySupport.makeLinear(D[3][0],D[3][1],3);
	Poly5 ZERO=new Poly5();
	Poly5[] X={a,b,c,d,ZERO};
	return X;
    }

    public static int[][] getCoords(int choice,int sign) {
	int[][] D=new int[4][2];
	if((choice==0)&&(sign==0))  D=AffineCubeData.B00();
	if((choice==0)&&(sign==1))  D=AffineCubeData.B01();
	if((choice==1)&&(sign==0))  D=AffineCubeData.B10();
	if((choice==1)&&(sign==1))  D=AffineCubeData.B11();
	return D;
    }

    /**Here is the basic polynomial which comoputes the change
       in bind energy*/

    public static PolyRat basic(int choice,int sign) {
	int[][] D=getCoords(choice,sign);
	return basic(D);
    }

    public static PolyRat basic(int[][] D) {
	Poly5 ZERO=new Poly5(); //zero polynomial
	Poly5[] A=getCube(D);
        Poly5 a=A[0];
	Poly5 b=A[1];
	Poly5 c=A[2];
	Poly5 d=A[3];
	Poly5 y1=Poly5.minus(d,c);
	Poly5 y3=Poly5.plus(d,c);
	Poly5[] P1={a,b,ZERO,y1,ZERO};
	Poly5[] P2={a,b,ZERO,y3,ZERO};
	Poly5[] P3={a,ZERO,ZERO,c,ZERO};
	PolyRat S=PolySupport.stereoFunction();
	PolyRat R1=S.compose(P1);
	PolyRat R2=S.compose(P2);
	PolyRat R3=S.compose(P3);
	R3.scale(new BigRational("2","1"));
	PolyRat R4=PolyRat.minus(PolyRat.plus(R1,R2),R3);
	return R4;
    }


    /**This is the positive quadratic term that is added to the
       bond energy polynomial.  The polynomial is 

        (map from cube to domain) composed with (x1^2/B+x3^2/D)

       The names are such that a,b,c,d,e=x0,x1,x2,x3,x4.  So,  
       B and D pertain to the b and d variables*/

    public static PolyRat positiveKick(int[][] C,int B,int D) {
	Poly5 P=new Poly5();
	P.count=2;
	int[] e0={0,2,0,0,0};
	int[] e1={0,0,0,2,0};
	int[] a={0,0};
        P.m[0]=new Mono5(new BigRational(1,B),e0);
        P.m[1]=new Mono5(new BigRational(1,D),e1);
	Poly5[] X=getCube(C);
	P=P.compose(X);
	PolyRat R=new PolyRat(P);
	return R;
    }



}

