import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.math.*;


/**This file contains routines which help us
assemble the polynomials which we test for
positive dominance.*/


public class PolySupport {


/**This routine makes the linear function
   p1 (1-x_j) + p2 (x_j).*/

    public static Poly5 makeLinear(long p1,long p2, int j) {
	BigRational R1=new BigRational(p1,512);
	BigRational R2=new BigRational(p2,512);
	int[] e0={0,0,0,0,0};
	int[] e1={0,0,0,0,0};
	e1[j]=1;
	Mono5 m0=new Mono5(R2,e1);
	Mono5 m1=new Mono5(R1,e0);
	Mono5 m2=new Mono5(R1.negate(),e1);
	Poly5 P=new Poly5();
	P.count=3;
	P.m[0]=new Mono5(m0);
	P.m[1]=new Mono5(m1);
	P.m[2]=new Mono5(m2);
	return P;
    }


/**This gives the main stereographic function, which
is  f(a,b,c,d) =  2-dist^2(s[a,b],s[c,d]).  Here dist is
chordal distance in R^3 and s is inverse stereographic
projection.  I copied the formula from the output of
Mathematica and (for debugging purposes) checked on
 random inputs that it is correct.  The polynomial only
 uses the first 4 variables*/

    public static PolyRat stereoFunction() {
	long[][] n1={{1,0,0,0,0,0},{1,2,0,0,0,0},{1,0,2,0,0,0}};
	long[][] n2={{1,0,0,0,0,0},{1,0,0,2,0,0},{1,0,0,0,2,0}};
	Poly5 N1=new Poly5(n1);
	Poly5 N2=new Poly5(n2);
	Poly5 N=Poly5.times(N1,N2);
	long[][] d={{4,2,0,0,0,0},{4,0,2,0,0,0},
                    {4,0,0,2,0,0},{4,0,0,0,2,0},
                    {-8,1,0,1,0,0},{-8,0,1,0,1,0}};
	Poly5 D=new Poly5(d);
	PolyRat R=new PolyRat(N,D);
	return R;
    }

    /**This computes the det of the Hessian with respect
       to the variables t_i and t_j*/

    public static Poly5 hessianDet(Poly5 P,int i,int j) {
	Poly5 P0=P.diff(i);
	Poly5 P00=P0.diff(i);
	Poly5 P1=P.diff(j);
	Poly5 P11=P1.diff(j);
	Poly5 P01=P0.diff(j);
	Poly5 Q=Poly5.minus(Poly5.times(P00,P11),Poly5.times(P01,P01));
	Q=PolyCompress.main(Q);
	return Q;
    }

    /**This computes the trace of the Hessian with respect
       to the variables t_i and t_j*/

    public static Poly5 hessianTrace(Poly5 P,int i,int j) {
	Poly5 P0=P.diff(i);
	Poly5 P00=P0.diff(i);
	Poly5 P1=P.diff(j);
	Poly5 P11=P1.diff(j);
	Poly5 Q=Poly5.plus(P00,P11);
	Q=PolyCompress.main(Q);
	return Q;
    }
}

