import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


/**This is the file that does all the positive
   dominance tests*/

public class PolyTester implements Runnable {
    Manager M;
    boolean HALT;

    public PolyTester() {
	HALT=true;
    }

    public PolyTester(Manager m) {
	M=m;
	HALT=true;
    }

    /**Here is the main routine.  We cycle through the
       16 polynomials and test (or not test)
       each one according to the specs on the control panel*/

    public void run() {
	resetPasses();
	HALT=false;
	int B=M.C.BCOEFF.val;
	int D=M.C.DCOEFF.val;
	int choice=0;
	while((choice<16)&&(HALT==false)) {
	    int[] A=selectSingle(choice);
	    int k=A[0];
	    int j=A[1];
	    int i=A[2];
	    if(doTest(i,j,k)==true) {
		M.C.PASS[i][j][k]=2;
		M.C.repaint();
                Poly5 P=getPoly(i,j,k,B,D);
	        boolean TEST=Poly5.isPositiveDominant(P);
		if(TEST==false) M.C.PASS[i][j][k]=0;
		if(TEST==true) M.C.PASS[i][j][k]=1;
		M.C.repaint();
	    }
	    ++choice;
	}
	HALT=true;
    }


    /**This decides if we actually test the polynomial*/

    public boolean doTest(int i,int j,int k) {
        int a=M.C.SYMM.L[i].on; 
        int b=M.C.POLY.L[j].on;
	int c=M.C.DOMAIN.L[k].on;
	if(a*b*c==1) return true;
	return false;
    }

    /**This resets the test display on the control panel*/

    public void resetPasses() {
	for(int i=0;i<2;++i) {
	    for(int j=0;j<2;++j) {
		for(int k=0;k<4;++k) M.C.PASS[i][j][k]=-1;
	    }
	}
    }

    /**This gets the relevant polynomial.  The values B and D
       are only used for Symm Lemma 2.*/

    public Poly5 getPoly(int i,int j,int k,int B,int D) {
	if(M.C.MAIN.mode==0) return getPolyPreset(i,j,k,B,D);
	return getPolyCustom(i,j,k,B,D);
    }

    /**This makes the polynomial associated to the preset domains*/

    public Poly5 getPolyPreset(int i,int j,int k,int B,int D) {
       Poly5 P=new Poly5();
       if((i==0)&&(j==0)) P=PolyLemma1.hessianTrace(k);
       if((i==0)&&(j==1)) P=PolyLemma1.hessianDet(k);
       if((i==1)&&(j==0)) P=PolyLemma2.hessianTrace(k,B,D);
       if((i==1)&&(j==1)) P=PolyLemma2.hessianDet(k,B,D);
       return P;
    }

    /**This makes the polynomial associated to the custom domain. 
       The values B and D are only used for Symm Lemma 2*/

    public Poly5 getPolyCustom(int i,int j,int k,int B,int D) {
       Poly5 P=new Poly5();
       int[][] C=M.C.CD.getCoords();
       if((i==0)&&(j==0)) P=PolyLemma1.hessianTrace(C);
       if((i==0)&&(j==1)) P=PolyLemma1.hessianDet(C);
       if((i==1)&&(j==0)) P=PolyLemma2.hessianTrace(C,B,D);
       if((i==1)&&(j==1)) P=PolyLemma2.hessianDet(C,B,D);
       return P;
    }

    /**This just turns an integer into the relevent list of indices*/
    public static int[] selectSingle(int t) {
        int t0=t%4;
	t=(t-t0)/4;
	int t1=t%2;
	t=(t-t1)/2;
	int t2=t%2;
	int[] A={t0,t1,t2};
	return A;
    }

}

