import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    ListenSquare RANDOM,GO,STOP;
    SymmetrizeTester SYMM=new SymmetrizeTester();
    SelectInteger RANGE0,RANGE1,RANGE2;  
    ControlPanel FUDGE,RAN,DISPLAY,MODE,FAIL,ANALYZE;
    SelectInteger[] CUSTOM=new SelectInteger[8];
    Color[] COL=new Color[4];

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 RANDOM=new ListenSquare(5,5,20,20);
	 GO=new ListenSquare(5,35,40,20);
	 STOP=new ListenSquare(55,35,40,20);
	 SYMM=new SymmetrizeTester();
	 RANGE0=new SelectInteger(5,65,40,20,0,0,6,1);
	 RANGE1=new SelectInteger(5,95,40,20,2,0,100,1);
	 RANGE2=new SelectInteger(105,95,40,20,2,0,100,1);
	 ControlPanelSetup.main(this);	
	 COL[0]=new Color(0,0,250);		
	 COL[1]=new Color(255,0,150);	
	 COL[2]=new Color(0,0,250);
	 COL[3]=new Color(250,0,150);
	 for(int i=0;i<7;++i) CUSTOM[i]=new SelectInteger(-1000,0,0,0,0,0,0,0);
	 CUSTOM[0]=new SelectInteger(10,425,40,20,500,0,800,1); 
	 CUSTOM[1]=new SelectInteger(10,450,40,20,524,0,800,1);  
	 CUSTOM[2]=new SelectInteger(10,475,40,20,8,0,256,1); 
	 CUSTOM[3]=new SelectInteger(10,500,40,20,500,0,800,1); 
	 CUSTOM[4]=new SelectInteger(10,525,40,20,524,0,800,1);  
	 CUSTOM[5]=new SelectInteger(10,550,40,20,8,0,256,1);    
	 CUSTOM[6]=new SelectInteger(110,425,50,25,4,0,9,1);   

     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.blue);
        g.fillRect(0,0,getWidth(),getHeight()); 

    }




    public void drawControls(Graphics2D g) {
	RANDOM.render(g,Color.black); 
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	g.drawString("random",30,20);
	if(SYMM.HALT==true) {
            GO.render(g,new Color(0,180,0));
	    g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
	}

	if(SYMM.HALT==false) {
            STOP.render(g,new Color(220,0,0));
	    g.drawString("stop",(int)(STOP.x+5),(int)(STOP.y+15));
	}

	g.drawString("selector strength",75,79);
	g.drawString("exponent lower and upper limits",5,129);
	MODE.render(g,100,145,98);
	FAIL.render(g,100,215,98);
	RAN.render(g,100,285,98);
	DISPLAY.render2(g,5,145,90);
	if(MODE.mode==1) {
           FUDGE.render(g,5,215,90);
           ANALYZE.render(g,5,300,90);
	}
	RANGE0.render2(g,new Color(150,0,250),Color.white,Color.white);
	RANGE1.render(g,Color.red,Color.white,Color.white);
	RANGE2.render(g,Color.red,Color.white,Color.white);
	for(int i=0;i<3;++i) CUSTOM[i].render(g,COL[0],Color.white,Color.white);
	for(int i=3;i<6;++i) CUSTOM[i].render(g,COL[1],Color.white,Color.white);
	CUSTOM[6].render2(g,Color.red,Color.white,Color.white);
	g.drawString("customize region (coord=val/512)",5,410);
    }

    public void doStop() {
	SYMM.HALT=true;
    }

    public void doGo() {
	if(SYMM.HALT==false) return; 
	SYMM=new SymmetrizeTester(this.M);
        new Thread(SYMM).start();
    }

    public void customize(Point X) {
	CUSTOM[6].modify(X);
	for(int i=0;i<6;++i) {
	    int step=CUSTOM[6].val;
	    step=(int)(Math.pow(2,step));
	    CUSTOM[i].step=step;
            CUSTOM[i].modify(X);
	}
    }

    public void setRange(Point X) {
	RANGE0.modify(X);
	int n=RANGE0.val;
	n=(int)(Math.pow(2,n));
	RANGE1.step=n;
	RANGE2.step=n;
	RANGE1.modify(X);
	RANGE2.modify(X);
    }
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	if(RANDOM.inside(J.X)==1) M.P.pickRandom();
	if(GO.inside(J.X)==1) doGo();
	if(STOP.inside(J.X)==1) doStop();
	setRange(J.X);
	int test=RAN.switchMode(J.X);
	if(test==20) DocumentControl.domain(M.D);
	test=FUDGE.switchMode(J.X);
	if(test==20) DocumentControl.fudge(M.D);
	test=MODE.switchMode(J.X);
	if(test==20) DocumentControl.symm(M.D);
	test=DISPLAY.toggle(J.X);
	if(test==20) DocumentControl.display(M.D);
	test=FAIL.switchMode(J.X);
	if(test==20) DocumentControl.fail(M.D);
	test=ANALYZE.switchMode(J.X);
	if(test==20) DocumentControl.analyze(M.D);
	customize(J.X);
	repaint();
	M.P.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	repaint();
	M.P.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    

}

