import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void domain(DocumentCanvas D) {
	String S="domain selection";
	S=S+"\n\nThis control panel lets you switch between two different domains.  One of the domains is \u03A9' (omega prime) from the monograph.  This is the domain used for the first symmetrization (Symm Lemma 1)  Given the way we do the testing for the second symmetrization (Symm Lemma 2), we automatically end up experimenting on points in \u03A9'' (omega double prime) for the second symmetrization.";

	S=S+"\n\nThe second domain is custom.  The 6 arrow keys select the sizes of the rectangles making the custom domain, and then a configuration is made by randomly sampling one point from each of the rectangles.  The 7th (red) arrow key lets you control how quickly you change the values of the other arrow keys.  You can experiment around and see the effect of using different arrow keys.  You should turn on the custom display to see the domain you are selecting.  When you make the domain you choose some integer, say X, and then the corresponding coordinate is X/512.  The domain is normalized so that the points z0 and z2 cannot lie in the lower half plane.";

	S=S+"\n\nThe third domain choice is a symmetrized version of the custom domain. Here the points z0 and z2 are allowed to lie in either the lower or upper halfplane. However, as in the monograph, the points always have the same y-coordinate.";

	sendTo(D,S);
    }


    public static void fail(DocumentCanvas D) {
	String S="display update";
	S=S+"\n\nWhen running, our tests check whether certain kinds of energy decrease under certain symmetrization operations.  In all cases, the test is made on random configurations within a certain domain. This option lets you decide if and how these configurations are displayed.  You can display none of them, just the ones which fail the test, or all of them.";

	sendTo(D,S);
    }

    public static void analyze(DocumentCanvas D) {
	String S="analyze failures";
	S=S+"\n\nIf this option is on, the program will interrupt the program if it fails in certain ways. Currently the test is designed with the init->middle symmetrization, and it tests a certain kind of pathological failure which can occur in custom domains. This option has nothing to do with the monograph and you should just leave it off. Sometimes I fool around with it and change what it does.";

	sendTo(D,S);
    }

    public static void fudge(DocumentCanvas D) {
	String S="fudge summand";
	S=S+"\n\nThis is a specialized window for the init->middle test.  It adds or subtracts a certain function to the energy total.  This is an experimental window.  Just ignore it and keep it set on 'none'.  When it is set to 'none', there is no fudge factor.  I will document this further if it becomes an established part of the program.";
	sendTo(D,S);
    }

    public static void bond(DocumentCanvas D) {
	String S="bond control";
	S=S+"\n\nThis control panel lets you select which bonds are tested. Actually, you can weight each of the bonds with a value of 0 (dark blue) 1 (light blue) or 2 (yellow) and then the energy you energy potential you test will be summed over the bonds with the given weights.  This convention is useful because I am interested in certain expressions, such as 2B01+2B21+B04+B24, where Bij denotes the bond between point i and point j. (These expressions do not make it into the monograph, but I have some other ideas for how to use them.)  You can also use the three buttons at top left to set everything at once to a desired weight.";

	sendTo(D,S);
    }




    public static void symm(DocumentCanvas D) {
	String S="test selection";
	S=S+"\n\nThis control panel lets you select which symmetrization operation is tested. The final symmetrization comes in two parts.  We start with an initial configuration in \u03A9', and then we do the symmetrization operation from Symm Lemma 1.  Call this the middle configuration.  We then do the symmetrization from Symm Lemma 2.  Call this the final configuration.  Let's denote these by INIT, MIDDLE, FINAL.";

	S=S+"\n\nSuppose that B is one of the bond sums that you have chosen, say the base.  Then there are 3 quantities you can look at:\n\nB(INIT)-B(FINAL).\n\nB(INIT)-B(MIDDLE).  This pertains Symm Lemma 1.\n\nB(MIDDLE)-B(FINAL). This pertains to Symm Lemma 2.";

	S=S+"\n\nAs I mentioned in the monograph, the main result, the Symmetrization Lemma, pertains to the calculation T(INIT)-T(FINAL) where T is the total potential.  However, the proof involves looking at the intermediate steps and also splitting up T into base+bow1+bow2.  I don't know a proof that does everything correctly. At this point I have to take these little steps.  This program serves as a sanity check that the intermediate lemmas are right.";

	S=S+"\n\nThis program, which uses floating point arithmetic, is not perfect. The answer could be positive, but so close to zero that floating point error makes it come out as a negative number.  In the case, the negative number would be about -10^{-17}. This somtimes happens for some of the tests, and of course it points out the need for interval arithmetic.";
	sendTo(D,S);
    }


    public static void display(DocumentCanvas D) {
	String S="configuration display.";

	S=S+"\n\nThere are 2 basic symmetrization operations.  Starting with an initial configuration, one can either produce the middle configuration or the final configuration.  Corresponding to these 2 operations there are three configurations: initial, middle, final. This control panel lets you toggle the display of these 3 configurations.";

	sendTo(D,S);
    }




    



}


