import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="Symmetrization Lemma Experiments\n\n";
	S=S+"This program is a companion to my monograph and it is related to the results in Part 4 having to do with symmetrization.  It does not have anything formally to the proofs but I did use (some version of) this program to discover the results and proofs about symmetrization.";

	    S=S+"\n\nThis window gives explanations for the rest of the program.  Drag the mouse over the text to scroll up or down. (There is more text than what is now visible.) The text in this window will change if you press some of the black ?-boxes sprinkled throughout the rest of the program. If you want to return this text, press the black ?-box at top left.";

	    S=S+"\n\nWhen this program opens, it shows two windows, this one and a control panel.  You can launch experiments from the control panel by pressing the go button.  When you run a test, you select the following information:\n\n1. A domain.  the default is the domain \u03A9' (the prime is deliberate) from the monograph.  You can also select a custom domain.\n\n2. A symmtrization procedure.\n\n3. A choice of which energy bonds to test.\n\n After you make these choices, the computer picks random instances of points in the domain and checks whether the selected symmetrization operation decreases the energy of the selected bonds.  A number is reported after every million tries.  For the test to work, this number should be positive, or at least positive up to floating point error.";

	    S=S+"\n\nYou can learn more about the various objects by clicking on the question boxes on the corresponding panels.";

	    S=S+"\n\nHere are some additional comments about the tests you can perform with this program.";

S=S+"\n\n1. Some of the tests are very close calls, and one can get a negative answer (about -10^{-17}) in some cases when the true answer is positive.  If you get an answer that is more negative thn about -10^{-15} then it is probably not floating point error.";

S=S+"\n\n2. The program is not equipped to test the precise polynomials that we consider for the proof of Symmetrization Lemma 2.  Rather, you can see experimentally that the following stronger statement holds true:  With respect to the exponent 12, the base energy in the intermediate->final test (the last option on the symm test control panel) is decreased by the symmetrization operation.  I did not know how to directly prove this stronger result, so in the monograph I proved something more complicated but still sufficient.";

S=S+"\n\n3. We sample points uniformly in our domains to make our tests.  While this seems like the simplest and most fair way to do it, this is actually misleading.  Theoretically, we might have a function that is negative very close to the boundary of the domain but otherwise positive, and our method of sampling probably would not reveal this.  A better method of sampling would be to concentrate around the boundary of the domain.  When I was using this program to discover what was really true, I had sophisticated sampling methods like this.  However, in order to make this program easier to use and understand, I eliminated them.  Since I have a proof, I really don't need these sophisticated methods to tell me what is true.  The simpler method currently used still serves as a good sanity check for the results.";



        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

