import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class EnergyPower {

    /**Here is the main routine.  Given the 4-tuple of
       complex numbers, we look at the inverse stereographic
       image, append the point (0,0,1) and give the list of
       10 bond energies for the given exponent.*/

    public static double[][] energyList(double e,Complex[] z) {
        double[][] V=toVector(z);
	double[][] L=energyList(e,V);
	return L;
    }



    /**inverse stereographic projection*/
    public static double[] inverseStereo(Complex z) {
	double d=1+z.x*z.x+z.y*z.y;
	double a=2*z.x/d;
	double b=2*z.y/d;
	double c=1-2/d;
	double[] V={a,b,c};
	return V;
    }

    public static double[][] toVector(Complex[] z) {
	double[][] V=new double[5][3];
	for(int i=0;i<4;++i) V[i]=inverseStereo(z[i]);
	V[4][0]=0;
	V[4][1]=0;
	V[4][2]=1;
	return V;
    }

    public static double distSquared(double[] V1,double[] V2) {
	double a=0;
	for(int i=0;i<3;++i) a=a+(V1[i]-V2[i])*(V1[i]-V2[i]);
	return a;
    }

    public static double interaction(double e,double[] V1,double[] V2) {
	double d=distSquared(V1,V2);
	d=Math.pow(d,-e/2);
	return(d);
    }

    public static double[][] energyList(double e,double[][] V) {
	double[][] t=new double[5][5];
	for(int i=0;i<5;++i) {
	    for(int j=i+1;j<5;++j) {
		t[i][j]=interaction(e,V[i],V[j]);
	    }
	}
	return(t);
    }

}


    
