import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] Z=new Complex[4];
    int STATUS;
    long COUNT;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(300,300,260);
	 Z[0]=new Complex(.9,0);
	 Z[1]=new Complex(0,-.8);
	 Z[2]=new Complex(-.9,0);
	 Z[3]=new Complex(0,.8);
	 STATUS=0;
	 pickRandom();
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTBP(g);
      drawCircle(g);
      if(M.C.RAN.mode==0) drawZone(g);
      if(M.C.RAN.mode!=0) drawZone2(g);
      if(M.C.DISPLAY.L[0].on==1) drawConfig0(g);
      if(M.C.DISPLAY.L[1].on==1) drawConfig1(g);
      if(M.C.DISPLAY.L[2].on==1) drawConfig2(g); 
      drawAxes(g);
      drawStatus(g);

   }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.black);
        g.fillRect(0,0,getWidth(),getHeight()); 
	g.setColor(Color.white);
        g.drawRect(0,0,getWidth()-1,getHeight()-1); 
    }	

    public void drawStatus(Graphics2D g) {
        g.setColor(new Color(20,20,20));
	if(STATUS==-1) g.setColor(new Color(255,0,0));
	if(STATUS==+1) g.setColor(new Color(0,200,0));
	if(STATUS==+2) g.setColor(new Color(255,200,0));
	g.fillRect(1,1,50,50);
	Long C=new Long(COUNT);
	g.setColor(Color.white); 
        g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.drawString(C.toString(),60,50);
    }


     
    public void drawCircle(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(1,0);
	for(int i=0;i<1000;++i) {
	    double t=2*Math.PI*i/1000;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    gp.lineTo(c,s);
	}
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.red);
	g.draw(gp);
    }

    public void drawAxes(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(1,0);
	gp.lineTo(-1,0);
	gp.moveTo(0,1);
	gp.lineTo(0,-1);
	gp=transform(gp);
	g.setColor(new Color(100,140,170));
	g.draw(gp);
    }

    public void drawConfig0(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(Z[0].x,Z[0].y);
	for(int i=1;i<4;++i) gp.lineTo(Z[i].x,Z[i].y);
	gp.closePath();
	gp=transform(gp);
	g.setColor(new Color(255,80,255));
	g.draw(gp);
    }


    public void drawConfig1(Graphics2D g) {
	Complex[] W=Symmetrize.symm(1,Z);
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(W[0].x,W[0].y);
	for(int i=1;i<4;++i) gp.lineTo(W[i].x,W[i].y);
	gp.closePath();
	gp=transform(gp);
	g.setColor(new Color(255,180,0));
	g.draw(gp);
    }

    public void drawConfig2(Graphics2D g) {
	Complex[] W=Symmetrize.symm(0,Z);
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(W[0].x,W[0].y);
	for(int i=1;i<4;++i) gp.lineTo(W[i].x,W[i].y);
	gp.closePath();
	gp=transform(gp);
	g.setColor(Color.white);
	g.draw(gp);
    }

    public void drawTBP(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(1,0);
	double x=Math.sqrt(3)/3;
	gp.lineTo(0,x);
	gp.lineTo(-1,0);
	gp.lineTo(0,-x);
	gp.closePath();
	gp=transform(gp);
	g.setColor(new Color(0,0,80));
	g.fill(gp);
    }

    public void drawZone(Graphics2D g) {
    Path2D.Double gp=new Path2D.Double();

    gp.moveTo(432.0/512,0);
    gp.lineTo(432.0/512,16.0/512);
    gp.lineTo(498.0/512,16.0/512);
    gp.lineTo(498.0/512,0);
    gp.closePath();
 
    gp.moveTo(-16.0/512,-465.0/512);
    gp.lineTo(-16.0/512,-348.0/512);
    gp.lineTo(+32.0/512,-348.0/512);
    gp.lineTo(+32.0/512,-465.0/512);
    gp.closePath();
 
    gp.moveTo(-498.0/512,0);
    gp.lineTo(-498.0/512,16.0/512);
    gp.lineTo(-400.0/512,16.0/512);
    gp.lineTo(-400.0/512,0);
    gp.closePath();
 
    gp.moveTo(-32.0/512,348.0/512);
    gp.lineTo(-32.0/512,465.0/512);
    gp.lineTo(+16.0/512,465.0/512);
    gp.lineTo(+16.0/512,348.0/512);
    gp.closePath();
 
    gp=transform(gp);
    g.setColor(new Color(0,0,150));
    g.fill(gp);
    g.setColor(Color.yellow);
    g.draw(gp);
    }


    public void drawZone2(Graphics2D g) {
    Path2D.Double[] gp=new Path2D.Double[4];
    for(int i=0;i<4;++i) gp[i]=new Path2D.Double();

    double[] d=new double[7];
    try{
       for(int i=0;i<7;++i) d[i]=M.C.CUSTOM[i].val/512.0;
    }
    catch(Exception e) {}

    double y=0;
    if(M.C.RAN.mode==2) y=-d[2];

    gp[0].moveTo(d[0],y);
    gp[0].lineTo(d[0],d[2]);
    gp[0].lineTo(d[1],d[2]);
    gp[0].lineTo(d[1],y);
    gp[0].closePath();
 
    gp[1].moveTo(-d[5],-d[3]);
    gp[1].lineTo(-d[5],-d[4]);
    gp[1].lineTo(+d[5],-d[4]);
    gp[1].lineTo(+d[5],-d[3]);
    gp[1].closePath();
 
    gp[2].moveTo(-d[1],y);
    gp[2].lineTo(-d[1],d[2]);
    gp[2].lineTo(-d[0],d[2]);
    gp[2].lineTo(-d[0],y);
    gp[2].closePath();
 
    gp[3].moveTo(-d[5],d[3]);
    gp[3].lineTo(-d[5],d[4]);
    gp[3].lineTo(+d[5],d[4]);
    gp[3].lineTo(+d[5],d[3]);
    gp[3].closePath();
 
    for(int i=0;i<4;++i) {
       gp[i]=transform(gp[i]);
       g.setColor(M.C.COL[i]);
       g.fill(gp[i]);
       g.setColor(new Color(0,200,200));
       g.draw(gp[i]);
    }
    }


    public void selectPoint() {
	if(SOURCE.x>.5) {
             Z[0]=new Complex(SOURCE);
	     Z[2].y=Z[0].y;
	}
	if(SOURCE.x<-.5) {
            Z[2]=new Complex(SOURCE);
	    Z[0].y=Z[2].y;
	}
	if(SOURCE.y>.5) Z[3]=new Complex(SOURCE);
	if(SOURCE.y<-.5) Z[1]=new Complex(SOURCE);
    }

    public void pickRandom() {
	int t=0;
	try {
	    t=M.C.RAN.mode;
	}
	catch(Exception e) {}
	double[] d=new double[7];
	try{
	    for(int i=0;i<7;++i) {
	      d[i]=M.C.CUSTOM[i].val/512.0;
	    }
	}
	catch(Exception e) {}
	Z=RandomGenerator.randomConfig(t,d);
    }

    public void mousePressed(MouseEvent e) { }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
        if(J.mode==2) {
           SOURCE=unTransform(J.X);
           selectPoint();
	}

	repaint();
	M.C.repaint();
    }
    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==2) {
           SOURCE=unTransform(J.X);
           selectPoint();
	}
	repaint();
	M.C.repaint();
    }
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   


}

