import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SelectCanvas extends ScaleCanvas implements MouseListener {
    Manager M;
    int[][] BOND=new int[5][5];
    Complex[] Z=new Complex[4];
    ListenSquare CONTROL,ON0,ON1,ON2,INFO;

     public SelectCanvas() {
	 addMouseListener(this);
	 setScales(150,150,150);
       
	Complex z=new Complex(.5,0);
	Complex w=new Complex(0,-1);
	for(int i=0;i<4;++i) {
	    Z[i]=new Complex(z);
	    z=Complex.times(z,w);
	}
	turnOn(1);
	CONTROL=new ListenSquare(0,0,130,70);
	ON0=new ListenSquare(20,0,20,20);
	ON1=new ListenSquare(40,0,20,20);
	ON2=new ListenSquare(60,0,20,20);
	INFO=new ListenSquare(0,0,12,12);
     }  

    public void turnOn(int k) {
       for(int i=0;i<5;++i) {
	    for(int j=0;j<5;++j) {
	      BOND[i][j]=k;
	    }
	 }
    }



   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawConfig(g);
    
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(100,0,100));
        g.fillRect(0,0,getWidth(),getHeight()); 
	CONTROL.render(g,Color.blue);
	ON0.render(g,new Color(0,0,100));
	ON1.render(g,new Color(90,150,255));
	ON2.render(g,new Color(255,255,0));
	INFO.infoRender(g);
    }


    public void drawConfig(Graphics2D g) {

	Color[] COL={new Color(0,0,100),new Color(90,150,255),new Color(255,255,0)};

	/**Base bonds*/
	g.setStroke(new BasicStroke(5));
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<4;++i) {
	    int j=(i+1)%4;
	    gp.reset();
	    gp.moveTo(Z[i].x,Z[i].y);
	    gp.lineTo(Z[j].x,Z[j].y);
	    gp=transform(gp);
	    g.setColor(COL[BOND[i][j]]);
	    g.draw(gp);
	}

	/**cross bonds*/
	for(int i=0;i<2;++i) {
	    int j=(i+2)%4;
	    gp.reset();
	    gp.moveTo(Z[i].x,Z[i].y);
	    gp.lineTo(Z[j].x,Z[j].y);
	    gp=transform(gp); 
            g.setColor(COL[BOND[i][j]]);
	    g.draw(gp);
	}

	/**outer bonds*/
	for(int i=0;i<4;++i) {
	    gp.reset();
	    gp.moveTo(Z[i].x,Z[i].y);
	    gp.lineTo(2*Z[i].x,2*Z[i].y);
	    gp=transform(gp);
            g.setColor(COL[BOND[i][4]]);
	    g.draw(gp);
	}

	for(int i=0;i<4;++i) {
	  drawDisk(g,Color.red,Color.white,Z[i],.1);
	}
    }


    public void locate(Complex z) {
	int i1=-1;
	int i2=-1;
	boolean outer=false;
	if((z.x>.5)&&(z.y*z.y<z.x*z.x)) {outer=true;i1=0;i2=4;}
	if((z.x<-.5)&&(z.y*z.y<z.x*z.x)) {outer=true;i1=2;i2=4;}
	if((z.y>.5)&&(z.y*z.y>z.x*z.x)) {outer=true;i1=3;i2=4;}
	if((z.y<-.5)&&(z.y*z.y>z.x*z.x)) {outer=true;i1=1;i2=4;}

	double min=1000;
	if(outer==false) {
	  for(int i=0;i<4;++i) {
	    for(int j=i+1;j<4;++j) {
		double test=Complex.area(z,Z[i],Z[j]);
		test=Math.abs(test);
		if(test<min) {
		    min=test;
		    i1=i;
		    i2=j;
		}
	    }
	  }
	}
	if(i1==-1) return;
	BOND[i1][i2]=(BOND[i1][i2]+1)%3;
	BOND[i2][i1]=(BOND[i2][i1]+1)%3;
    }



    public void drawDisk(Graphics2D g,Color C1,Color C2,Complex z,double r) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<32;++i) {
	    double t=2*Math.PI*i/32;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    if(i==0) gp.moveTo(z.x+c*r,z.y+s*r);
	    if(i!=0) gp.lineTo(z.x+c*r,z.y+s*r);
	}
	gp.closePath();
	gp=transform(gp);
	g.setColor(C1);
	g.fill(gp);
	g.setColor(C2);
	g.draw(gp);
    }
    
    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	SOURCE=unTransform(J.X);
	if(CONTROL.inside(J.X)==0) locate(SOURCE);
	if(ON0.inside(J.X)==1) turnOn(0);
	if(ON1.inside(J.X)==1) turnOn(1);
	if(ON2.inside(J.X)==1) turnOn(2);
	if(INFO.inside(J.X)==1) DocumentControl.bond(M.D);
	repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
}

