import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**These are some extra routines that do not have to to
with the monograph.  They have to do with testing the
first symmetrization operation (init->middle) over some
custom domains.*/


public class SymmTesterExtra {

    public static void analyzeFail(Complex[] z) {
        double[][] i0=EnergyPower.energyList(2,z);
	Complex[] zz=Symmetrize.symm1(z);
        double[][] i1=EnergyPower.energyList(2,zz);
	double a=i0[0][4]+i0[2][4]-2*i1[0][4];a=a/2;
	double b=i0[0][3]+i0[2][3]-2*i1[0][3];

	boolean bad=true;

	if(i1[0][3]<i1[0][4]) bad=false;
	if(i0[0][3]>i1[0][3]) bad=false;
	if(i0[2][3]>i1[0][3]) bad=false;
	if(i0[0][4]+i0[0][3]>2*i1[0][3]) bad=false;
	if(i0[2][4]+i0[0][3]>2*i1[0][3]) bad=false;
	if(i0[0][4]+i0[2][3]>2*i1[0][3]) bad=false;
	if(i0[2][4]+i0[2][3]>2*i1[0][3]) bad=false;
	if(i0[2][4]+i0[0][4]>2*i1[0][3]) bad=false;

	if(bad==true) {
 	  System.out.println(i0[0][4]+" "+i0[2][4]+"   "+i1[0][4]+" "+a);
	  System.out.println(i0[0][3]+" "+i0[2][3]+"   "+i1[0][3]+" "+b);
	  System.out.println(i1[0][3]+" "+i1[2][3]);
          throw new ProofException("bad example");
	}
    }

    /**This routine is designed to work with the partial
       symmetrization test.  Option 0 returns 0.
       Option 1 returns a small negative number corresponding
       to the fact that partial symmetrization is highly
       favorable for bow1.
       Options 2 and 3 return small negative numbers
       corresponding to the fact that partial symmetriation
       can be somewhat unfavorable for wedge1 and wedge3.
       The numbers are designed so that
       (opt1) + (opt2) + (opt3) < 0 */

    public static double fudge(int choice,double s,Complex[] z) {
	if(choice==0) return 0;
	double t=.5*s;
	double c=.5*(z[0].x+z[2].x);
	Complex[] z1=Symmetrize.symm1(z);
	double[][] v=EnergyPower.toVector(z1);
	double y0=EnergyPower.distSquared(v[0],v[4]);
	double y1=EnergyPower.distSquared(v[1],v[4]);
	double y2=EnergyPower.distSquared(v[3],v[4]);
	double y=0;
	if(choice==1) y=1/y0;
	if(choice==2) y=Math.min(1/y0,1/y1);
	if(choice==3) y=Math.min(1/y0,1/y2);
	double coeff=-1.0/2;
	if(choice>1) coeff=1.0/4;
	return coeff*t*Math.pow(y,t)*c*c;
    }


}
    
